/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.dsl;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.BucketSortAggregation;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.opensearch._types.aggregations.CalendarInterval;
import org.opensearch.client.opensearch._types.aggregations.CardinalityAggregation;
import org.opensearch.client.opensearch._types.aggregations.ChildrenAggregation;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramAggregation;
import org.opensearch.client.opensearch._types.aggregations.FiltersAggregation;
import org.opensearch.client.opensearch._types.aggregations.ParentAggregation;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.aggregations.TopHitsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.util.ObjectBuilder;
import org.springframework.lang.Nullable;

public interface AggregationDSL {
    public static BucketSortAggregation bucketSortAggregation(@Nullable Integer size, SortOptions ... sortOptions) {
        return BucketSortAggregation.of(a -> a.sort(Arrays.asList(sortOptions)).size(size));
    }

    public static CardinalityAggregation cardinalityAggregation(String field) {
        return CardinalityAggregation.of(a -> (ObjectBuilder)a.field(field));
    }

    public static CardinalityAggregation cardinalityAggregation(String field, int precisionThreshold) {
        return CardinalityAggregation.of(a -> ((CardinalityAggregation.Builder)a.field(field)).precisionThreshold(Integer.valueOf(precisionThreshold)));
    }

    public static CalendarInterval calendarIntervalByAlias(String alias) {
        return Arrays.stream(CalendarInterval.values()).filter(ci -> Arrays.asList(ci.aliases()).contains(alias)).findFirst().orElseThrow(() -> {
            List legalAliases = Arrays.stream(CalendarInterval.values()).flatMap(v -> Arrays.stream(v.aliases())).sorted().toList();
            return new OperateRuntimeException(String.format("Unknown CalendarInterval alias %s! Legal aliases: %s", alias, legalAliases));
        });
    }

    public static DateHistogramAggregation dateHistogramAggregation(String field, String calendarIntervalAlias, String format, boolean keyed) {
        return DateHistogramAggregation.of(a -> a.field(field).calendarInterval(AggregationDSL.calendarIntervalByAlias(calendarIntervalAlias)).format(format).keyed(Boolean.valueOf(keyed)));
    }

    public static FiltersAggregation filtersAggregation(Map<String, Query> queries) {
        return FiltersAggregation.of(a -> a.filters(Buckets.of(b -> b.keyed(queries))));
    }

    public static TermsAggregation termAggregation(String field, int size) {
        return TermsAggregation.of(a -> a.field(field).size(Integer.valueOf(size)));
    }

    public static TermsAggregation termAggregation(String field, int size, Map<String, SortOrder> orderBy) {
        return TermsAggregation.of(a -> a.field(field).size(Integer.valueOf(size)).order(orderBy, new Map[0]));
    }

    public static TopHitsAggregation topHitsAggregation(List<String> sourceFields, int size, SortOptions ... sortOptions) {
        return TopHitsAggregation.of(a -> a.source(QueryDSL.sourceInclude(sourceFields)).size(Integer.valueOf(size)).sort(List.of(sortOptions)));
    }

    public static TopHitsAggregation topHitsAggregation(int size, SortOptions ... sortOptions) {
        return TopHitsAggregation.of(a -> a.size(Integer.valueOf(size)).sort(List.of(sortOptions)));
    }

    public static Aggregation withSubaggregations(DateHistogramAggregation aggregation, Map<String, Aggregation> aggregations) {
        return Aggregation.of(a -> a.dateHistogram(aggregation).aggregations(aggregations));
    }

    public static Aggregation withSubaggregations(FiltersAggregation aggregation, Map<String, Aggregation> aggregations) {
        return Aggregation.of(a -> a.filters(aggregation).aggregations(aggregations));
    }

    public static Aggregation withSubaggregations(ChildrenAggregation childrenAggregation, Map<String, Aggregation> aggregations) {
        return Aggregation.of(a -> a.children(childrenAggregation).aggregations(aggregations));
    }

    public static Aggregation withSubaggregations(Query query, Map<String, Aggregation> aggregations) {
        return Aggregation.of(a -> a.filter(query).aggregations(aggregations));
    }

    public static Aggregation withSubaggregations(TermsAggregation aggregation, Map<String, Aggregation> aggregations) {
        return Aggregation.of(a -> a.terms(aggregation).aggregations(aggregations));
    }

    public static ParentAggregation parent(String type) {
        return ParentAggregation.of(p -> p.type(type));
    }

    public static ChildrenAggregation children(String type) {
        return ChildrenAggregation.of(c -> c.type(type));
    }
}

