/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.store.opensearch.client.OpenSearchFailedShardsException;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchSyncOperation;
import io.camunda.operate.util.ExceptionHelper;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.function.CheckedSupplier;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.tasks.GetTasksResponse;
import org.opensearch.client.opensearch.tasks.Info;
import org.opensearch.client.opensearch.tasks.Status;
import org.slf4j.Logger;

public abstract class OpenSearchRetryOperation
extends OpenSearchSyncOperation {
    public static final int UPDATE_RETRY_COUNT = 3;
    public static final int DEFAULT_DELAY_INTERVAL_IN_SECONDS = 2;
    public static final int DEFAULT_NUMBER_OF_RETRIES = 300;
    private final int delayIntervalInSeconds = 2;
    private final int numberOfRetries = 300;

    public OpenSearchRetryOperation(Logger logger, OpenSearchClient openSearchClient) {
        super(logger, openSearchClient);
    }

    protected <T> T executeWithRetries(CheckedSupplier<T> supplier) {
        return this.executeWithRetries("", supplier, null);
    }

    protected <T> T executeWithRetries(String operationName, CheckedSupplier<T> supplier) {
        return this.executeWithRetries(operationName, supplier, null);
    }

    protected <T> T executeWithRetries(String operationName, CheckedSupplier<T> supplier, Predicate<T> retryPredicate) {
        return this.executeWithGivenRetries(300, operationName, supplier, retryPredicate);
    }

    protected <T> T executeWithGivenRetries(int retries, String operationName, CheckedSupplier<T> operation, Predicate<T> predicate) {
        try {
            RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handle(new Class[]{IOException.class, OpenSearchException.class, OpenSearchFailedShardsException.class})).withDelay(Duration.ofSeconds(2L)).withMaxAttempts(retries).onRetry(e -> this.logger.info("Retrying #{} {} due to {}", new Object[]{e.getAttemptCount(), operationName, e.getLastFailure()})).onAbort(e -> this.logger.error("Abort {} by {}", (Object)operationName, (Object)e.getFailure())).onRetriesExceeded(e -> this.logger.error("Retries {} exceeded for {}", (Object)e.getAttemptCount(), (Object)operationName));
            if (predicate != null) {
                retryPolicy.handleResultIf(predicate);
            }
            return (T)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(operation);
        }
        catch (Exception e2) {
            throw new OperateRuntimeException("Couldn't execute operation " + operationName + " on opensearch for " + retries + " attempts with 2 seconds waiting.", (Throwable)e2);
        }
    }

    protected GetTasksResponse task(String id) throws IOException {
        return this.openSearchClient.tasks().get(t -> t.taskId(id));
    }

    protected Map<String, Info> tasksWithActions(List<String> actions) throws IOException {
        return this.openSearchClient.tasks().list(l -> l.actions(actions)).tasks();
    }

    protected GetTasksResponse waitTaskCompletion(String taskId) {
        String[] taskIdParts = taskId.split(":");
        String nodeId = taskIdParts[0];
        long id = Long.parseLong(taskIdParts[1]);
        return this.executeWithGivenRetries(Integer.MAX_VALUE, "GetTaskInfo{" + nodeId + "},{" + id + "}", () -> {
            this.checkTaskErrorsOrFailures(nodeId, (int)id);
            return this.task(taskId);
        }, this::needsToPollAgain);
    }

    private void checkTaskErrorsOrFailures(String node, Integer id) throws IOException {
        GetTasksResponse tasks = ExceptionHelper.withIOException(() -> this.task(node + ":" + id));
        if (tasks != null) {
            this.checkForErrors(tasks);
            this.checkForFailures(tasks);
        }
    }

    private void checkForErrors(GetTasksResponse taskResponse) {
        if (taskResponse.error() != null) {
            throw new OperateRuntimeException(taskResponse.error().reason());
        }
    }

    private void checkForFailures(GetTasksResponse taskResponse) {
        if (taskResponse.response().failures() != null) {
            throw new OperateRuntimeException((String)taskResponse.response().failures().get(0));
        }
    }

    private boolean needsToPollAgain(GetTasksResponse taskResponse) {
        Status r = taskResponse.response();
        boolean allTasksExecuted = r.total() == r.created() + r.updated() + r.deleted();
        return !taskResponse.completed() || !allTasksExecuted;
    }
}

