/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.schema.IndexMapping;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchRetryOperation;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.rest.RestStatus;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch.core.ReindexRequest;
import org.opensearch.client.opensearch.core.ReindexResponse;
import org.opensearch.client.opensearch.indices.AnalyzeRequest;
import org.opensearch.client.opensearch.indices.AnalyzeResponse;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.ExistsAliasRequest;
import org.opensearch.client.opensearch.indices.GetAliasResponse;
import org.opensearch.client.opensearch.indices.GetIndexRequest;
import org.opensearch.client.opensearch.indices.GetIndexResponse;
import org.opensearch.client.opensearch.indices.GetIndicesSettingsResponse;
import org.opensearch.client.opensearch.indices.GetMappingResponse;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.IndexState;
import org.opensearch.client.opensearch.indices.PutIndicesSettingsRequest;
import org.opensearch.client.opensearch.indices.PutIndicesSettingsResponse;
import org.opensearch.client.opensearch.indices.PutMappingRequest;
import org.opensearch.client.opensearch.indices.PutMappingResponse;
import org.opensearch.client.opensearch.indices.RefreshRequest;
import org.opensearch.client.opensearch.indices.RefreshResponse;
import org.opensearch.client.opensearch.indices.UpdateAliasesRequest;
import org.opensearch.client.opensearch.indices.get_mapping.IndexMappingRecord;
import org.opensearch.client.opensearch.indices.update_aliases.Action;
import org.opensearch.client.opensearch.indices.update_aliases.AddAction;
import org.opensearch.client.opensearch.tasks.GetTasksResponse;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;

public class OpenSearchIndexOperations
extends OpenSearchRetryOperation {
    public static final String NUMBERS_OF_REPLICA = "index.number_of_replicas";
    public static final String NO_REPLICA = "0";
    public static final String REFRESH_INTERVAL = "index.refresh_interval";
    public static final String NO_REFRESH = "-1";
    private final ObjectMapper objectMapper;

    public OpenSearchIndexOperations(Logger logger, OpenSearchClient openSearchClient, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        super(logger, openSearchClient);
        this.objectMapper = objectMapper;
    }

    private static String defaultIndexErrorMessage(String index) {
        return String.format("Failed to search index: %s", index);
    }

    public Set<String> getIndexNamesWithRetries(String namePattern) {
        return (Set)this.executeWithRetries("Get indices for " + namePattern, () -> {
            try {
                GetIndexResponse response = this.openSearchClient.indices().get(i -> i.index(namePattern, new String[0]));
                return response.result().keySet();
            }
            catch (OpenSearchException e) {
                if (e.status() == RestStatus.NOT_FOUND.getStatus()) {
                    return Set.of();
                }
                throw e;
            }
        });
    }

    public Set<String> getAliasesNamesWithRetries(String namePattern) {
        return (Set)this.executeWithRetries("Get aliases for " + namePattern, () -> {
            try {
                GetAliasResponse response = this.openSearchClient.indices().getAlias(i -> i.index(namePattern, new String[0]));
                return response.result().values().stream().map(a -> a.aliases()).map(a -> a.keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
            }
            catch (OpenSearchException e) {
                if (e.status() == RestStatus.NOT_FOUND.getStatus()) {
                    return Set.of();
                }
                throw e;
            }
        });
    }

    public boolean createIndexWithRetries(CreateIndexRequest createIndexRequest) {
        return (Boolean)this.executeWithRetries("CreateIndex " + createIndexRequest.index(), () -> {
            String aliasName;
            if (!this.indicesExist(createIndexRequest.index())) {
                return this.openSearchClient.indices().create(createIndexRequest).acknowledged();
            }
            if (createIndexRequest.aliases() != null && !createIndexRequest.aliases().isEmpty() && !this.aliasExists(aliasName = (String)createIndexRequest.aliases().keySet().iterator().next())) {
                Action action = (Action)new Action.Builder().add(new AddAction.Builder().alias(aliasName).index(createIndexRequest.index()).isWriteIndex(Boolean.valueOf(false)).build()).build();
                UpdateAliasesRequest request = new UpdateAliasesRequest.Builder().actions(List.of(action)).build();
                this.openSearchClient.indices().updateAliases(request);
                this.logger.info("Alias is created. Index: {}, alias: {} ", (Object)createIndexRequest.index(), (Object)aliasName);
            }
            return true;
        });
    }

    private boolean aliasExists(String aliasName) throws IOException {
        ExistsAliasRequest aliasExistsReq = new ExistsAliasRequest.Builder().name(List.of(aliasName)).build();
        return this.openSearchClient.indices().existsAlias(aliasExistsReq).value();
    }

    private boolean indicesExist(String indexPattern) throws IOException {
        return this.openSearchClient.indices().exists(e -> e.index(List.of(indexPattern)).ignoreUnavailable(Boolean.valueOf(true)).allowNoIndices(Boolean.valueOf(false))).value();
    }

    public long getNumberOfDocumentsWithRetries(String ... indexPatterns) {
        return (Long)this.executeWithRetries("Count number of documents in " + String.valueOf(Arrays.asList(indexPatterns)), () -> this.openSearchClient.count(c -> c.index(List.of(indexPatterns))).count());
    }

    public boolean indexExists(String index) {
        return this.safe(() -> this.openSearchClient.indices().exists(r -> r.index(index, new String[0])).value(), e -> OpenSearchIndexOperations.defaultIndexErrorMessage(index));
    }

    public void refresh(String indexPattern) {
        RefreshRequest refreshRequest = new RefreshRequest.Builder().index(List.of(indexPattern)).build();
        try {
            RefreshResponse refresh = this.openSearchClient.indices().refresh(refreshRequest);
            if (refresh.shards().failures().size() > 0) {
                this.logger.warn("Unable to refresh indices: {}", (Object)indexPattern);
            }
        }
        catch (Exception ex) {
            this.logger.warn(String.format("Unable to refresh indices: %s", indexPattern), (Throwable)ex);
        }
    }

    public void refresh(String ... indexPatterns) {
        RefreshRequest refreshRequest = new RefreshRequest.Builder().index(List.of(indexPatterns)).build();
        try {
            RefreshResponse refresh = this.openSearchClient.indices().refresh(refreshRequest);
            if (refresh.shards().failures().size() > 0) {
                this.logger.warn("Unable to refresh indices: {}", List.of(indexPatterns));
            }
        }
        catch (Exception ex) {
            this.logger.warn(String.format("Unable to refresh indices: %s", List.of(indexPatterns)), (Throwable)ex);
        }
    }

    public void refreshWithRetries(String indexPattern) {
        this.executeWithRetries("Refresh " + indexPattern, () -> {
            try {
                for (String index : this.getFilteredIndices(indexPattern)) {
                    this.openSearchClient.indices().refresh(r -> r.index(List.of(index)));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        });
    }

    private Set<String> getFilteredIndices(String indexPattern) throws IOException {
        return this.openSearchClient.indices().get(i -> i.index(List.of(indexPattern))).result().keySet();
    }

    public boolean deleteIndicesWithRetries(String indexPattern) {
        return (Boolean)this.executeWithRetries("DeleteIndices " + indexPattern, () -> {
            for (String index : this.getFilteredIndices(indexPattern)) {
                this.openSearchClient.indices().delete(d -> d.index(List.of(indexPattern)));
            }
            return true;
        });
    }

    public IndexSettings getIndexSettingsWithRetries(String indexName) {
        return (IndexSettings)this.executeWithRetries("GetIndexSettings " + indexName, () -> {
            GetIndicesSettingsResponse response = this.openSearchClient.indices().getSettings(s -> s.index(List.of(indexName)));
            IndexSettings settings = ((IndexState)response.result().get(indexName)).settings();
            return settings.index() == null ? settings : settings.index();
        });
    }

    public Map<String, IndexMapping> getIndexMappings(String indexNamePattern) {
        return (Map)this.executeWithRetries("GetIndexMappings " + indexNamePattern, () -> {
            HashMap<String, IndexMapping> mappings = new HashMap<String, IndexMapping>();
            GetMappingResponse response = this.openSearchClient.indices().getMapping(s -> s.index(indexNamePattern, new String[0]));
            for (Map.Entry indexMapping : response.result().entrySet()) {
                HashSet<IndexMapping.IndexMappingProperty> properties = new HashSet<IndexMapping.IndexMappingProperty>();
                for (Map.Entry entry : ((IndexMappingRecord)indexMapping.getValue()).mappings().properties().entrySet()) {
                    Property propertyVariant = (Property)entry.getValue();
                    String string = this.toJsonString((JsonpSerializable)propertyVariant);
                    Map indexMappingAsMap = (Map)this.objectMapper.readValue(string, (TypeReference)new TypeReference<HashMap<String, Object>>(this){});
                    properties.add(new IndexMapping.IndexMappingProperty().setName((String)entry.getKey()).setTypeDefinition(indexMappingAsMap));
                }
                String dynamic = ((IndexMappingRecord)indexMapping.getValue()).mappings().dynamic() == null ? null : ((IndexMappingRecord)indexMapping.getValue()).mappings().dynamic().name();
                HashMap<String, Object> metaFields = new HashMap<String, Object>();
                if (((IndexMappingRecord)indexMapping.getValue()).mappings().meta() != null) {
                    for (Map.Entry entry : ((IndexMappingRecord)indexMapping.getValue()).mappings().meta().entrySet()) {
                        metaFields.put((String)entry.getKey(), ((JsonData)entry.getValue()).deserialize(JsonpDeserializer.booleanDeserializer()));
                    }
                }
                IndexMapping mapping = new IndexMapping().setIndexName((String)indexMapping.getKey()).setDynamic(dynamic).setProperties(properties).setMetaProperties(metaFields);
                mappings.put((String)indexMapping.getKey(), mapping);
            }
            return mappings;
        });
    }

    public PutMappingResponse putMapping(PutMappingRequest putMappingRequest) {
        return (PutMappingResponse)this.executeWithRetries("PutMapping " + String.valueOf(putMappingRequest.index()), () -> this.openSearchClient.indices().putMapping(putMappingRequest));
    }

    public Map<String, Object> getIndexSettings(String indexName) {
        return this.withExtendedOpenSearchClient(extendedOpenSearchClient -> this.safe(() -> (Map)extendedOpenSearchClient.arbitraryRequest("GET", "/" + indexName, "{}").get(indexName), e -> String.format("Failed to get index settings for %s", indexName)));
    }

    public String getOrDefaultRefreshInterval(String indexName, String defaultValue) {
        String refreshInterval;
        Time refreshIntervalTime = this.getIndexSettingsWithRetries(indexName).refreshInterval();
        String string = refreshInterval = refreshIntervalTime == null ? defaultValue : refreshIntervalTime.time();
        if (refreshInterval.trim().equals(NO_REFRESH)) {
            refreshInterval = defaultValue;
        }
        return refreshInterval;
    }

    public String getOrDefaultNumbersOfReplica(String indexName, String defaultValue) {
        String numbersOfReplica;
        String numberOfReplicasOriginal = this.getIndexSettingsWithRetries(indexName).numberOfReplicas();
        String string = numbersOfReplica = numberOfReplicasOriginal == null ? defaultValue : numberOfReplicasOriginal;
        if (numbersOfReplica.trim().equals(NO_REPLICA)) {
            numbersOfReplica = defaultValue;
        }
        return numbersOfReplica;
    }

    public PutIndicesSettingsResponse putSettings(PutIndicesSettingsRequest request) throws IOException {
        return this.openSearchClient.indices().putSettings(request);
    }

    public PutIndicesSettingsResponse setIndexLifeCycle(String index, String value) throws IOException {
        PutIndicesSettingsRequest request = PutIndicesSettingsRequest.of(b -> b.index(index, new String[0]).settings(s -> s.lifecycleName(value)));
        return this.putSettings(request);
    }

    public boolean setIndexSettingsFor(IndexSettings settings, String indexPattern) {
        return (Boolean)this.executeWithRetries("SetIndexSettings " + indexPattern, () -> this.openSearchClient.indices().putSettings(s -> s.index(indexPattern, new String[0]).settings(settings)).acknowledged());
    }

    public AnalyzeResponse analyze(AnalyzeRequest analyzeRequest) throws IOException {
        return this.openSearchClient.indices().analyze(analyzeRequest);
    }

    public void reindexWithRetries(ReindexRequest reindexRequest) {
        this.reindexWithRetries(reindexRequest, true);
    }

    public void reindexWithRetries(ReindexRequest reindexRequest, boolean checkDocumentCount) {
        this.executeWithRetries("Reindex " + String.valueOf(Arrays.asList(reindexRequest.source().index())) + " -> " + reindexRequest.dest().index(), () -> {
            String dstIndex;
            long dstCount;
            String srcIndices = (String)reindexRequest.source().index().get(0);
            long srcCount = this.getNumberOfDocumentsWithRetries(srcIndices);
            if (checkDocumentCount && srcCount == (dstCount = this.getNumberOfDocumentsWithRetries((dstIndex = reindexRequest.dest().index()) + "*"))) {
                this.logger.info("Reindex of {} -> {} is already done.", (Object)srcIndices, (Object)dstIndex);
                return true;
            }
            ReindexResponse response = this.openSearchClient.reindex(reindexRequest);
            if (response.total().equals(srcCount)) {
                String taskId = response.task() != null ? response.task() : "task:unavailable";
                this.logProgress(taskId, srcCount, srcCount);
                return true;
            }
            TimeUnit.of(ChronoUnit.MILLIS).sleep(2000L);
            return this.waitUntilTaskIsCompleted(response.task(), srcCount);
        }, done -> done == false);
    }

    private boolean waitUntilTaskIsCompleted(String taskId, long srcCount) {
        GetTasksResponse taskResponse = this.waitTaskCompletion(taskId);
        if (taskResponse != null) {
            this.logProgress(taskId, taskResponse.response().total(), srcCount);
            long total = taskResponse.response().total();
            this.logger.info("Source docs: {}, Migrated docs: {}", (Object)srcCount, (Object)total);
            return total == srcCount;
        }
        return false;
    }

    private void logProgress(String taskId, long processed, long srcCount) {
        double progress = (double)processed * 100.0 / (double)srcCount;
        this.logger.info("TaskId: {}, Progress: {}%", (Object)taskId, (Object)String.format("%.2f", progress));
    }

    public GetIndexResponse get(GetIndexRequest.Builder requestBuilder) {
        GetIndexRequest request = requestBuilder.build();
        return this.safe(() -> this.openSearchClient.indices().get(request), e -> "Failed to get index " + String.valueOf(request.index()));
    }
}

