/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import io.camunda.operate.store.opensearch.client.sync.OpenSearchRetryOperation;
import java.util.Map;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.slf4j.Logger;

public class OpenSearchISMOperations
extends OpenSearchRetryOperation {
    public OpenSearchISMOperations(Logger logger, OpenSearchClient openSearchClient) {
        super(logger, openSearchClient);
    }

    public Map<String, Object> addPolicyToIndex(String index, String policy) {
        String json = String.format("{\"policy_id\": \"%s\"}", policy);
        return this.withExtendedOpenSearchClient(extendedOpenSearchClient -> this.safe(() -> extendedOpenSearchClient.arbitraryRequest("POST", "/_plugins/_ism/add/" + index, json), e -> String.format("Failed to add policy %s to index %s", policy, index)));
    }

    public Map<String, Object> createPolicy(String policyName, String policyJson) {
        return this.withExtendedOpenSearchClient(extendedOpenSearchClient -> this.safe(() -> extendedOpenSearchClient.arbitraryRequest("PUT", "/_plugins/_ism/policies/" + policyName, policyJson), e -> String.format("Failed to create policy: %s", policyName)));
    }

    public Map<String, Object> deletePolicy(String policyName) {
        return this.withExtendedOpenSearchClient(extendedOpenSearchClient -> this.safe(() -> extendedOpenSearchClient.arbitraryRequest("DELETE", "/_plugins/_ism/policies/" + policyName, "{}"), e -> String.format("Failed to delete policy: %s", policyName)));
    }

    public Map<String, Object> getPolicy(String policyName) {
        return this.withExtendedOpenSearchClient(extendedOpenSearchClient -> this.safe(() -> extendedOpenSearchClient.arbitraryRequest("GET", "/_plugins/_ism/policies/" + policyName, "{}"), e -> String.format("Failed to get policy: %s", policyName)));
    }
}

