/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import io.camunda.operate.opensearch.ExtendedOpenSearchClient;
import io.camunda.operate.store.NotFoundException;
import io.camunda.operate.store.opensearch.client.OpenSearchFailedShardsException;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchRetryOperation;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.util.ObjectBuilderBase;
import org.slf4j.Logger;

public class OpenSearchDocumentOperations
extends OpenSearchRetryOperation {
    public static final String SCROLL_KEEP_ALIVE_MS = "60000ms";
    public static final String INTERNAL_SCROLL_KEEP_ALIVE_MS = "30000ms";
    public static final int TERMS_AGG_SIZE = 10000;
    public static final int TOPHITS_AGG_SIZE = 100;

    public OpenSearchDocumentOperations(Logger logger, OpenSearchClient openSearchClient) {
        super(logger, openSearchClient);
    }

    private static Function<Exception, String> defaultSearchErrorMessage(String index) {
        return e -> String.format("Failed to search index: %s! Reason: %s", index, e.getMessage());
    }

    private static String defaultDeleteErrorMessage(String index) {
        return String.format("Failed to delete index: %s", index);
    }

    private static String defaultPersistErrorMessage(String index) {
        return String.format("Failed to persist index: %s", index);
    }

    private void clearScroll(String scrollId) {
        if (scrollId != null) {
            try {
                this.openSearchClient.clearScroll(RequestDSL.clearScrollRequest(scrollId));
            }
            catch (Exception e) {
                this.logger.warn("Error occurred when clearing the scroll with id [{}]", (Object)scrollId);
            }
        }
    }

    private void checkFailedShards(SearchRequest request, SearchResponse<?> response) {
        if (!response.shards().failures().isEmpty()) {
            throw new OpenSearchFailedShardsException(String.format("Shards failed executing request (request=%s, failed shards=%s)", request, response.shards().failures()));
        }
    }

    public <R> Map<String, Aggregate> unsafeScrollWith(SearchRequest.Builder searchRequestBuilder, Consumer<List<Hit<R>>> hitsConsumer, Consumer<HitsMetadata<R>> hitsMetadataConsumer, Class<R> clazz, boolean retry) throws IOException {
        SearchRequest request = searchRequestBuilder.scroll(RequestDSL.time(SCROLL_KEEP_ALIVE_MS)).build();
        return retry ? (Map)this.executeWithRetries(() -> this.scrollWith(request, hitsConsumer, hitsMetadataConsumer, clazz)) : this.scrollWith(request, hitsConsumer, hitsMetadataConsumer, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> Map<String, Aggregate> scrollWith(SearchRequest request, Consumer<List<Hit<R>>> hitsConsumer, Consumer<HitsMetadata<R>> hitsMetadataConsumer, Class<R> clazz) throws IOException {
        String scrollId = null;
        try {
            SearchResponse response = this.openSearchClient.search(request, clazz);
            Map aggregates = response.aggregations();
            if (hitsMetadataConsumer != null) {
                hitsMetadataConsumer.accept(response.hits());
            }
            scrollId = response.scrollId();
            List hits = response.hits().hits();
            while (!hits.isEmpty() && scrollId != null) {
                this.checkFailedShards(request, response);
                if (hitsConsumer != null) {
                    hitsConsumer.accept(hits);
                }
                response = this.openSearchClient.scroll(RequestDSL.scrollRequest(scrollId), clazz);
                scrollId = response.scrollId();
                hits = response.hits().hits();
            }
            Map map = aggregates;
            if (scrollId != null) {
                this.clearScroll(scrollId);
            }
            return map;
        }
        catch (Throwable throwable) {
            if (scrollId != null) {
                this.clearScroll(scrollId);
            }
            throw throwable;
        }
    }

    private <R> Map<String, Aggregate> safeScrollWith(SearchRequest.Builder requestBuilder, Class<R> entityClass, Consumer<List<Hit<R>>> hitsConsumer) {
        return this.safeScrollWith(requestBuilder, entityClass, hitsConsumer, null);
    }

    private <R> Map<String, Aggregate> safeScrollWith(SearchRequest.Builder requestBuilder, Class<R> entityClass, Consumer<List<Hit<R>>> hitsConsumer, Consumer<HitsMetadata<R>> hitsMetadataConsumer) {
        return this.safe(() -> this.unsafeScrollWith(requestBuilder, hitsConsumer, hitsMetadataConsumer, entityClass, false), OpenSearchDocumentOperations.defaultSearchErrorMessage(this.getIndex((ObjectBuilderBase)requestBuilder)));
    }

    private <R> AggregatedResult<R> scroll(SearchRequest.Builder searchRequestBuilder, Class<R> clazz, boolean retry) throws IOException {
        AggregatedResult<Hit<R>> result = this.scrollHits(searchRequestBuilder, clazz, retry);
        return new AggregatedResult<Object>(result.values().stream().map(Hit::source).toList(), result.aggregates());
    }

    public <R> AggregatedResult<Hit<R>> scrollHits(SearchRequest.Builder searchRequestBuilder, Class<R> clazz) throws IOException {
        ArrayList result = new ArrayList();
        Map<String, Aggregate> aggregates = this.unsafeScrollWith(searchRequestBuilder, result::addAll, null, clazz, false);
        return new AggregatedResult<Hit<R>>(result, aggregates);
    }

    public <R> AggregatedResult<Hit<R>> scrollHits(SearchRequest.Builder searchRequestBuilder, Class<R> clazz, boolean retry) throws IOException {
        ArrayList result = new ArrayList();
        Map<String, Aggregate> aggregates = this.unsafeScrollWith(searchRequestBuilder, result::addAll, null, clazz, retry);
        return new AggregatedResult<Hit<R>>(result, aggregates);
    }

    public <R> void scrollWith(SearchRequest.Builder requestBuilder, Class<R> entityClass, Consumer<List<Hit<R>>> hitsConsumer) {
        this.safeScrollWith(requestBuilder, entityClass, hitsConsumer);
    }

    public <R> void scrollWith(SearchRequest.Builder requestBuilder, Class<R> entityClass, Consumer<List<Hit<R>>> hitsConsumer, Consumer<HitsMetadata<R>> hitsMetadataConsumer) {
        this.safeScrollWith(requestBuilder, entityClass, hitsConsumer, hitsMetadataConsumer);
    }

    public <R> AggregatedResult<R> scrollValuesAndAggregations(SearchRequest.Builder requestBuilder, Class<R> entityClass) {
        return this.safe(() -> this.scroll(requestBuilder, entityClass, false), OpenSearchDocumentOperations.defaultSearchErrorMessage(this.getIndex((ObjectBuilderBase)requestBuilder)));
    }

    public <R> AggregatedResult<R> scrollValuesAndAggregations(SearchRequest.Builder requestBuilder, Class<R> entityClass, boolean retry) {
        return this.safe(() -> this.scroll(requestBuilder, entityClass, retry), OpenSearchDocumentOperations.defaultSearchErrorMessage(this.getIndex((ObjectBuilderBase)requestBuilder)));
    }

    public <R> List<R> scrollValues(SearchRequest.Builder requestBuilder, Class<R> entityClass) {
        return this.scrollValuesAndAggregations(requestBuilder, entityClass).values();
    }

    public <R> List<R> scrollValues(SearchRequest.Builder requestBuilder, Class<R> entityClass, boolean retry) {
        return this.scrollValuesAndAggregations(requestBuilder, entityClass, retry).values();
    }

    private <R> SearchResponse<R> unsafeSearch(SearchRequest request, Class<R> entityClass) throws IOException {
        SearchResponse response = this.openSearchClient.search(request, entityClass);
        this.checkFailedShards(request, response);
        return response;
    }

    public <R> SearchResponse<R> search(SearchRequest.Builder requestBuilder, Class<R> entityClass) {
        return this.search(requestBuilder, entityClass, false);
    }

    public <R> SearchResponse<R> search(SearchRequest.Builder requestBuilder, Class<R> entityClass, boolean retry) {
        SearchRequest request = requestBuilder.build();
        return retry ? (SearchResponse)this.executeWithRetries(() -> this.unsafeSearch(request, entityClass)) : this.safe(() -> this.unsafeSearch(request, entityClass), OpenSearchDocumentOperations.defaultSearchErrorMessage(this.getIndex((ObjectBuilderBase)requestBuilder)));
    }

    public <R> List<R> searchValues(SearchRequest.Builder requestBuilder, Class<R> entityClass) {
        return this.searchValues(requestBuilder, entityClass, false);
    }

    public <R> List<R> searchValues(SearchRequest.Builder requestBuilder, Class<R> entityClass, boolean retry) {
        return this.search(requestBuilder, entityClass, retry).hits().hits().stream().map(Hit::source).toList();
    }

    public Map<String, Aggregate> searchAggregations(SearchRequest.Builder requestBuilder) {
        requestBuilder.size(Integer.valueOf(0));
        return this.search(requestBuilder, Void.class).aggregations();
    }

    public <R> R searchUnique(SearchRequest.Builder requestBuilder, Class<R> entityClass, String key) {
        SearchResponse<R> response = this.search(requestBuilder, entityClass);
        if (response.hits().total().value() == 1L) {
            return (R)((Hit)response.hits().hits().get(0)).source();
        }
        if (response.hits().total().value() > 1L) {
            throw new NotFoundException(String.format("Could not find unique %s with key '%s'.", this.getIndex((ObjectBuilderBase)requestBuilder), key));
        }
        throw new NotFoundException(String.format("Could not find %s with key '%s'.", this.getIndex((ObjectBuilderBase)requestBuilder), key));
    }

    public long docCount(SearchRequest.Builder requestBuilder) {
        requestBuilder.size(Integer.valueOf(0));
        return this.search(requestBuilder, Void.class).hits().total().value();
    }

    public Map<String, String> getIndexNames(String index, Collection<String> ids) {
        HashMap<String, String> result = new HashMap<String, String>();
        SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder().index(index, new String[0]).query(QueryDSL.ids(ids)).source(s -> s.fetch(Boolean.valueOf(false)));
        Consumer hitsConsumer = hits -> hits.forEach(hit -> result.put(hit.id(), hit.index()));
        this.safeScrollWith(searchRequestBuilder, Void.class, hitsConsumer);
        return result;
    }

    public boolean documentExistsWithGivenRetries(String name, String id) {
        return (Boolean)this.executeWithGivenRetries(10, String.format("Exists document from %s with id %s", name, id), () -> this.openSearchClient.exists(e -> e.index(name).id(id)).value(), null);
    }

    public <R> Optional<R> getWithRetries(String index, String id, Class<R> entitiyClass) {
        return (Optional)this.executeWithRetries(() -> {
            GetResponse response = this.openSearchClient.get(RequestDSL.getRequest(index, id), entitiyClass);
            return response.found() ? Optional.ofNullable(response.source()) : Optional.empty();
        });
    }

    public DeleteResponse delete(String index, String id) {
        DeleteRequest.Builder deleteRequestBuilder = new DeleteRequest.Builder().index(index).id(id);
        return this.safe(() -> this.openSearchClient.delete(deleteRequestBuilder.build()), e -> OpenSearchDocumentOperations.defaultDeleteErrorMessage(index));
    }

    public DeleteByQueryResponse delete(String index, String field, String value) {
        DeleteByQueryRequest.Builder deleteRequestBuilder = new DeleteByQueryRequest.Builder().index(index, new String[0]).query(QueryDSL.term(field, value));
        return this.safe(() -> this.openSearchClient.deleteByQuery(deleteRequestBuilder.build()), e -> OpenSearchDocumentOperations.defaultDeleteErrorMessage(index));
    }

    public boolean deleteWithRetries(String index, Query query) {
        return (Boolean)this.executeWithRetries(() -> {
            DeleteByQueryRequest request = RequestDSL.deleteByQueryRequestBuilder(index).query(query).build();
            DeleteByQueryResponse response = this.openSearchClient.deleteByQuery(request);
            return response.failures().isEmpty() && response.deleted() > 0L;
        });
    }

    public long deleteByQuery(String index, Query query) {
        return (Long)this.executeWithRetries(() -> {
            DeleteByQueryRequest request = RequestDSL.deleteByQueryRequestBuilder(index).query(query).build();
            DeleteByQueryResponse response = this.openSearchClient.deleteByQuery(request);
            return response.deleted();
        });
    }

    public boolean deleteWithRetries(String index, String id) {
        return (Boolean)this.executeWithRetries(() -> this.openSearchClient.delete(RequestDSL.deleteRequestBuilder(index, id).build()).result() == Result.Deleted);
    }

    public <A> IndexResponse index(IndexRequest.Builder<A> requestBuilder) {
        return this.safe(() -> this.openSearchClient.index(requestBuilder.build()), e -> OpenSearchDocumentOperations.defaultPersistErrorMessage(this.getIndex((ObjectBuilderBase)requestBuilder)));
    }

    public <A> boolean indexWithRetries(IndexRequest.Builder<A> requestBuilder) {
        IndexRequest indexRequest = requestBuilder.build();
        return (Boolean)this.executeWithRetries(() -> {
            IndexResponse response = this.openSearchClient.index(indexRequest);
            return List.of(Result.Created, Result.Updated).contains(response.result());
        });
    }

    public <A> UpdateResponse<Void> update(UpdateRequest.Builder<Void, A> requestBuilder, Function<Exception, String> errorMessageSupplier) {
        return this.safe(() -> this.openSearchClient.update(requestBuilder.build(), Void.class), errorMessageSupplier);
    }

    public <R> SearchResponse<R> fixedSearch(SearchRequest request, Class<R> classR) {
        OpenSearchClient openSearchClient = this.openSearchClient;
        if (openSearchClient instanceof ExtendedOpenSearchClient) {
            ExtendedOpenSearchClient extendedOpenSearchClient = (ExtendedOpenSearchClient)openSearchClient;
            return this.safe(() -> extendedOpenSearchClient.fixedSearch(request, classR), e -> OpenSearchDocumentOperations.defaultDeleteErrorMessage(request.index().toString()));
        }
        throw new UnsupportedOperationException("ExtendedOpenSearchClient is required to execute fixedSearch! Provided: " + this.openSearchClient.getClass().getName());
    }

    public Map<String, Object> searchAsMap(SearchRequest.Builder requestBuilder) {
        SearchRequest request = requestBuilder.size(Integer.valueOf(0)).build();
        OpenSearchClient openSearchClient = this.openSearchClient;
        if (openSearchClient instanceof ExtendedOpenSearchClient) {
            ExtendedOpenSearchClient extendedOpenSearchClient = (ExtendedOpenSearchClient)openSearchClient;
            return this.safe(() -> extendedOpenSearchClient.searchAsMap(request), e -> OpenSearchDocumentOperations.defaultDeleteErrorMessage(request.index().toString()));
        }
        throw new UnsupportedOperationException("ExtendedOpenSearchClient is required to execute fixedSearch! Provided: " + this.openSearchClient.getClass().getName());
    }

    public record AggregatedResult<R>(List<R> values, Map<String, Aggregate> aggregates) {
    }
}

