/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.async;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.store.opensearch.client.async.OpenSearchAsyncOperation;
import io.camunda.operate.util.BackoffIdleStrategy;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.tasks.GetTasksResponse;
import org.opensearch.client.opensearch.tasks.Status;
import org.slf4j.Logger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class OpenSearchAsyncTaskOperations
extends OpenSearchAsyncOperation {
    public OpenSearchAsyncTaskOperations(Logger logger, OpenSearchAsyncClient openSearchAsyncClient) {
        super(logger, openSearchAsyncClient);
    }

    private static String defaultTaskErrorMessage(String id) {
        return String.format("Failed to fetch task %s", id);
    }

    public CompletableFuture<GetTasksResponse> task(String id) {
        return this.safe(() -> this.openSearchAsyncClient.tasks().get(b -> b.taskId(id)), e -> OpenSearchAsyncTaskOperations.defaultTaskErrorMessage(id));
    }

    public CompletableFuture<Long> totalImpactedByTask(final String taskId, final ThreadPoolTaskScheduler executor) {
        final CompletableFuture<Long> result = new CompletableFuture<Long>();
        final BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(1000L, 1.2f, 5000L);
        Runnable checkTaskResultRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    OpenSearchAsyncTaskOperations.this.task(taskId).whenComplete((response, e) -> {
                        if (e != null) {
                            result.completeExceptionally((Throwable)new OperateRuntimeException("Task not found: " + taskId, e));
                        } else if (response.completed()) {
                            Status status = response.task().status();
                            if (status.created() + status.updated() + status.deleted() < status.total()) {
                                String errorMsg = String.format("Failures occurred during task %s execution! Check Opensearch logs.", taskId);
                                throw new OperateRuntimeException(errorMsg);
                            }
                            OpenSearchAsyncTaskOperations.this.logger.debug("Task {} succeeded.", (Object)taskId);
                            result.complete(status.total());
                        } else {
                            idleStrategy.idle();
                            executor.schedule((Runnable)this, Date.from(Instant.now().plusMillis(idleStrategy.idleTime())));
                        }
                    });
                }
                catch (Exception e2) {
                    result.completeExceptionally(e2);
                }
            }
        };
        executor.submit(checkTaskResultRunnable);
        return result;
    }
}

