/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.ErrorType;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.IncidentState;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.store.IncidentStore;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchDocumentOperations;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchIncidentStore
implements IncidentStore {
    public static final Query ACTIVE_INCIDENT_QUERY = TermQuery.of(q -> q.field("state").value(FieldValue.of((String)IncidentState.ACTIVE.name())))._toQuery();
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchIncidentStore.class);
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    private IncidentTemplate incidentTemplate;
    @Autowired
    private OperateProperties operateProperties;

    private Query activeIncidentConstantScore(Query q) {
        return QueryDSL.constantScore(QueryDSL.and(ACTIVE_INCIDENT_QUERY, q));
    }

    @Override
    public IncidentEntity getIncidentById(Long incidentKey) {
        String key = incidentKey.toString();
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.incidentTemplate, RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.withTenantCheck(this.activeIncidentConstantScore(QueryDSL.ids(key))));
        return this.richOpenSearchClient.doc().searchUnique(searchRequestBuilder, IncidentEntity.class, key);
    }

    @Override
    public List<IncidentEntity> getIncidentsWithErrorTypesFor(String treePath, List<Map<ErrorType, Long>> errorTypes) {
        String errorTypesAggName = "errorTypesAgg";
        SearchRequest.Builder request = RequestDSL.searchRequestBuilder(this.incidentTemplate, RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.withTenantCheck(QueryDSL.constantScore(QueryDSL.and(QueryDSL.term("treePath", treePath), ACTIVE_INCIDENT_QUERY)))).aggregations(Map.of("errorTypesAgg", AggregationDSL.termAggregation("errorType", ErrorType.values().length, Map.of("_key", SortOrder.Asc))._toAggregation()));
        OpenSearchDocumentOperations.AggregatedResult<IncidentEntity> result = this.richOpenSearchClient.doc().scrollValuesAndAggregations(request, IncidentEntity.class);
        result.aggregates().get("errorTypesAgg").sterms().buckets().array().forEach(b -> {
            ErrorType errorType = ErrorType.valueOf(b.key());
            errorTypes.add(Map.of(errorType, b.docCount()));
        });
        return result.values();
    }

    @Override
    public List<IncidentEntity> getIncidentsByProcessInstanceKey(Long processInstanceKey) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.incidentTemplate, RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.withTenantCheck(this.activeIncidentConstantScore(QueryDSL.term("processInstanceKey", processInstanceKey)))).sort(QueryDSL.sortOptions("creationTime", SortOrder.Asc), new SortOptions[0]);
        return this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, IncidentEntity.class);
    }

    @Override
    public List<IncidentEntity> getIncidentsByErrorHashCode(Integer incidentErrorHashCode) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.incidentTemplate, RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.withTenantCheck(this.activeIncidentConstantScore(QueryDSL.term("errorMessageHash", incidentErrorHashCode)))).sort(QueryDSL.sortOptions("creationTime", SortOrder.Asc), new SortOptions[0]);
        return this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, IncidentEntity.class);
    }

    @Override
    public Map<Long, List<Long>> getIncidentKeysPerProcessInstance(List<Long> processInstanceKeys) {
        int batchSize = this.operateProperties.getOpensearch().getBatchSize();
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.incidentTemplate, RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.withTenantCheck(this.activeIncidentConstantScore(QueryDSL.longTerms("processInstanceKey", processInstanceKeys)))).source(QueryDSL.sourceInclude("processInstanceKey")).size(Integer.valueOf(batchSize));
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        record Result(Long processInstanceKey) {
        }
        this.richOpenSearchClient.doc().search(searchRequestBuilder, Result.class).hits().hits().forEach(hit -> CollectionUtil.addToMap((Map)result, (Object)((Result)hit.source()).processInstanceKey(), (Object)Long.valueOf(hit.id())));
        return result;
    }
}

