/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch.dao;

import io.camunda.operate.util.ElasticsearchUtil;
import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class Query {
    private QueryBuilder queryBuilder = null;
    private AggregationBuilder aggregationBuilder = null;
    private String groupName = null;

    public static Query whereEquals(String field, String value) {
        Query instance = new Query();
        instance.queryBuilder = QueryBuilders.termsQuery((String)field, (String[])new String[]{value});
        return instance;
    }

    public static Query range(String field, Object gte, Object lte) {
        Query instance = new Query();
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)field);
        if (gte != null) {
            rangeQueryBuilder = rangeQueryBuilder.gte(gte);
        }
        if (lte != null) {
            rangeQueryBuilder = rangeQueryBuilder.lte(lte);
        }
        instance.queryBuilder = rangeQueryBuilder;
        return instance;
    }

    public Query aggregate(String groupName, String fieldName, int limit) {
        TermsAggregationBuilder aggregation = AggregationBuilders.terms((String)groupName);
        aggregation.field(fieldName);
        aggregation.size(limit);
        this.aggregationBuilder = aggregation;
        this.groupName = groupName;
        return this;
    }

    public Query aggregate(String groupName, String fieldName) {
        return this.aggregate(groupName, fieldName, Integer.MAX_VALUE);
    }

    public Query and(Query andQuery) {
        this.queryBuilder = ElasticsearchUtil.joinWithAnd(this.queryBuilder, andQuery.queryBuilder);
        return this;
    }

    public Query or(Query orQuery) {
        this.queryBuilder = ElasticsearchUtil.joinWithOr(this.queryBuilder, orQuery.queryBuilder);
        return this;
    }

    QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    AggregationBuilder getAggregationBuilder() {
        return this.aggregationBuilder;
    }

    String getGroupName() {
        return this.groupName;
    }

    public int hashCode() {
        return Objects.hash(this.queryBuilder, this.aggregationBuilder, this.groupName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equals(this.queryBuilder, query.queryBuilder) && Objects.equals(this.aggregationBuilder, query.aggregationBuilder) && Objects.equals(this.groupName, query.groupName);
    }

    public String toString() {
        return "Query{queryBuilder=" + String.valueOf(this.queryBuilder) + ", aggregationBuilder=" + String.valueOf(this.aggregationBuilder) + ", groupName='" + this.groupName + "'}";
    }
}

