/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.store.ZeebeStore;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchZeebeStore
implements ZeebeStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeStore.class);
    @Autowired
    @Qualifier(value="zeebeEsClient")
    private RestHighLevelClient zeebeEsClient;
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public void refreshIndex(String indexPattern) {
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{indexPattern});
        try {
            RefreshResponse refresh = this.zeebeEsClient.indices().refresh(refreshRequest, RequestOptions.DEFAULT);
            if (refresh.getFailedShards() > 0) {
                LOGGER.warn("Unable to refresh indices: {}", (Object)indexPattern);
            }
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("Unable to refresh indices: %s", indexPattern), (Throwable)ex);
        }
    }

    @Override
    public boolean zeebeIndicesExists(String indexPattern) {
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{indexPattern});
            request.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)false, (boolean)true, (boolean)false));
            boolean exists = this.zeebeEsClient.indices().exists(request, RequestOptions.DEFAULT);
            if (exists) {
                LOGGER.debug("Data already exists in Zeebe.");
            }
            return exists;
        }
        catch (IOException io) {
            LOGGER.debug("Error occurred while checking existence of data in Zeebe: {}. Demo data won't be created.", (Object)io.getMessage());
            return false;
        }
    }
}

