/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.store.TaskStore;
import io.camunda.operate.store.elasticsearch.dao.response.TaskResponse;
import io.camunda.operate.util.Either;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.tasks.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchTaskStore
implements TaskStore {
    public static final String ID = "id";
    public static final String REASON = "reason";
    public static final String CAUSE = "cause";
    public static final String CREATED = "created";
    public static final String TASK_ACTION_INDICES_REINDEX = "indices:data/write/reindex";
    public static final String DESCRIPTION_PREFIX_FROM_INDEX = "reindex from [";
    public static final String DESCRIPTION_PREFIX_TO_INDEX = "to [";
    private static final String TASKS_ENDPOINT = "_tasks";
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchTaskStore.class);
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;

    public Either<IOException, TaskResponse> getTaskResponse(String taskId) {
        try {
            Request request = new Request("GET", "/_tasks/" + taskId);
            Response response = this.esClient.getLowLevelClient().performRequest(request);
            TaskResponse taskResponse = (TaskResponse)this.objectMapper.readValue(response.getEntity().getContent(), TaskResponse.class);
            return Either.right((Object)taskResponse);
        }
        catch (IOException e) {
            return Either.left((Object)e);
        }
    }

    public void checkForErrorsOrFailures(TaskResponse taskResponse) {
        this.checkForErrors(taskResponse);
        this.checkForFailures(taskResponse);
    }

    @Override
    public List<String> getRunningReindexTasksIdsFor(String fromIndex, String toIndex) throws IOException {
        if (fromIndex == null || toIndex == null) {
            return List.of();
        }
        return this.getReindexTasks().stream().filter(taskInfo -> this.descriptionContainsReindexFromTo(taskInfo.getDescription(), fromIndex, toIndex)).map(this::toTaskId).toList();
    }

    private String toTaskId(TaskInfo taskInfo) {
        return String.format("%s:%s", taskInfo.getTaskId().getNodeId(), taskInfo.getTaskId().getId());
    }

    private boolean descriptionContainsReindexFromTo(String description, String fromIndex, String toIndex) {
        return description != null && description.contains(DESCRIPTION_PREFIX_FROM_INDEX + fromIndex) && description.contains(DESCRIPTION_PREFIX_TO_INDEX + toIndex);
    }

    private List<TaskInfo> getReindexTasks() throws IOException {
        ListTasksResponse response = this.esClient.tasks().list(((ListTasksRequest)new ListTasksRequest().setActions(new String[]{TASK_ACTION_INDICES_REINDEX})).setDetailed(true), RequestOptions.DEFAULT);
        return response.getTasks();
    }

    private void checkForErrors(TaskResponse taskResponse) {
        if (taskResponse != null && taskResponse.getError() != null) {
            TaskResponse.Error error = taskResponse.getError();
            LOGGER.error("Task status contains error: " + String.valueOf(error));
            throw new OperateRuntimeException(error.getReason());
        }
    }

    private void checkForFailures(TaskResponse taskStatus) {
        TaskResponse.TaskResponseDetails taskResponse;
        List<Object> failures;
        if (taskStatus != null && taskStatus.getResponseDetails() != null && !(failures = (taskResponse = taskStatus.getResponseDetails()).getFailures()).isEmpty()) {
            Map failure = (Map)failures.get(0);
            Map cause = (Map)failure.get(CAUSE);
            throw new OperateRuntimeException((String)cause.get(REASON));
        }
    }

    public boolean needsToPollAgain(Optional<TaskResponse> maybeTaskResponse) {
        return maybeTaskResponse.isEmpty() || maybeTaskResponse.filter(tr -> !tr.isCompleted()).isPresent();
    }
}

