/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.Metrics;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.meta.ImportPositionEntity;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.IndexMapping;
import io.camunda.operate.schema.indices.ImportPositionIndex;
import io.camunda.operate.store.ImportStore;
import io.camunda.operate.store.elasticsearch.RetryElasticsearchClient;
import io.camunda.operate.util.Either;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchImportStore
implements ImportStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchImportStore.class);
    @Autowired
    private ImportPositionIndex importPositionType;
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private RetryElasticsearchClient retryElasticsearchClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private Metrics metrics;
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public ImportPositionEntity getImportPositionByAliasAndPartitionId(String alias, int partitionId) throws IOException {
        QueryBuilder queryBuilder = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"aliasName", (String)alias), QueryBuilders.termQuery((String)"partitionId", (int)partitionId)});
        SearchRequest searchRequest = new SearchRequest(new String[]{this.importPositionType.getAlias()}).source(new SearchSourceBuilder().query(queryBuilder).size(10));
        SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
        Iterator hitIterator = searchResponse.getHits().iterator();
        ImportPositionEntity position = new ImportPositionEntity().setAliasName(alias).setPartitionId(partitionId);
        if (hitIterator.hasNext()) {
            position = ElasticsearchUtil.fromSearchHit(((SearchHit)hitIterator.next()).getSourceAsString(), this.objectMapper, ImportPositionEntity.class);
        }
        LOGGER.debug("Latest loaded position for alias [{}] and partitionId [{}]: {}", new Object[]{alias, partitionId, position});
        return position;
    }

    @Override
    public Either<Throwable, Boolean> updateImportPositions(List<ImportPositionEntity> positions, List<ImportPositionEntity> postImportPositions) {
        Either<Exception, BulkRequest> preparedBulkRequest = this.prepareBulkRequest(positions);
        if (preparedBulkRequest.isLeft()) {
            Exception e = (Exception)preparedBulkRequest.getLeft();
            return Either.left((Object)e);
        }
        if ((preparedBulkRequest = this.addPostImportRequests((BulkRequest)preparedBulkRequest.get(), postImportPositions)).isLeft()) {
            Exception e = (Exception)preparedBulkRequest.getLeft();
            return Either.left((Object)e);
        }
        try {
            BulkRequest bulkRequest = (BulkRequest)preparedBulkRequest.get();
            this.withImportPositionTimer(() -> {
                ElasticsearchUtil.processBulkRequest(this.esClient, bulkRequest, this.operateProperties.getElasticsearch().getBulkRequestMaxSizeInBytes());
                return null;
            });
            return Either.right((Object)true);
        }
        catch (Throwable e) {
            LOGGER.error("Error occurred while persisting latest loaded position", e);
            return Either.left((Object)e);
        }
    }

    @Override
    public void setConcurrencyMode(boolean concurrencyMode) {
        this.retryElasticsearchClient.updateMetaField(this.importPositionType, "concurrencyMode", concurrencyMode);
    }

    @Override
    public boolean getConcurrencyMode() {
        String indexName = this.importPositionType.getFullQualifiedName();
        Map<String, IndexMapping> indexMappings = this.retryElasticsearchClient.getIndexMappings(indexName);
        if (indexMappings.get(indexName).getMetaProperties() == null) {
            return false;
        }
        Object concurrencyMode = indexMappings.get(indexName).getMetaProperties().get("concurrencyMode");
        return concurrencyMode == null ? false : (Boolean)concurrencyMode;
    }

    private void withImportPositionTimer(Callable<Void> action) throws Exception {
        this.metrics.getTimer("operate.import.position.update", new String[0]).recordCallable(action);
    }

    private Either<Exception, BulkRequest> prepareBulkRequest(List<ImportPositionEntity> positions) {
        BulkRequest bulkRequest = new BulkRequest();
        if (positions.size() > 0) {
            Either preparedUpdateRequests = (Either)positions.stream().map(this::prepareUpdateRequest).collect(Either.collectorFoldingLeft());
            if (preparedUpdateRequests.isLeft()) {
                Exception e = (Exception)preparedUpdateRequests.getLeft();
                return Either.left((Object)e);
            }
            ((List)preparedUpdateRequests.get()).forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
        }
        return Either.right((Object)bulkRequest);
    }

    private Either<Exception, BulkRequest> addPostImportRequests(BulkRequest bulkRequest, List<ImportPositionEntity> positions) {
        if (positions.size() > 0) {
            Either preparedUpdateRequests = (Either)positions.stream().map(this::preparePostImportUpdateRequest).collect(Either.collectorFoldingLeft());
            if (preparedUpdateRequests.isLeft()) {
                Exception e = (Exception)preparedUpdateRequests.getLeft();
                return Either.left((Object)e);
            }
            ((List)preparedUpdateRequests.get()).forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
        }
        return Either.right((Object)bulkRequest);
    }

    private Either<Exception, UpdateRequest> preparePostImportUpdateRequest(ImportPositionEntity position) {
        try {
            String index = this.importPositionType.getFullQualifiedName();
            String source = this.objectMapper.writeValueAsString((Object)position);
            HashMap<String, Long> updateFields = new HashMap<String, Long>();
            updateFields.put("postImporterPosition", position.getPostImporterPosition());
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(position.getId()).upsert(source, XContentType.JSON).doc(updateFields);
            return Either.right((Object)updateRequest);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error occurred while preparing request to update processed position for %s", position.getAliasName()), (Throwable)e);
            return Either.left((Object)e);
        }
    }

    private Either<Exception, UpdateRequest> prepareUpdateRequest(ImportPositionEntity position) {
        try {
            String index = this.importPositionType.getFullQualifiedName();
            String source = this.objectMapper.writeValueAsString((Object)position);
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("position", position.getPosition());
            updateFields.put("indexName", position.getIndexName());
            updateFields.put("sequence", position.getSequence());
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(position.getId()).upsert(source, XContentType.JSON).doc(updateFields);
            return Either.right((Object)updateRequest);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error occurred while preparing request to update processed position for %s", position.getAliasName()), (Throwable)e);
            return Either.left((Object)e);
        }
    }
}

