/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store;

import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.entities.listview.ProcessInstanceForListViewEntity;
import io.camunda.operate.entities.listview.ProcessInstanceState;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.lang.Nullable;

public interface ProcessStore {
    public Optional<Long> getDistinctCountFor(String var1);

    public void refreshIndices(String ... var1);

    public ProcessEntity getProcessByKey(Long var1);

    public String getDiagramByKey(Long var1);

    public Map<ProcessKey, List<ProcessEntity>> getProcessesGrouped(String var1, @Nullable Set<String> var2);

    public Map<Long, ProcessEntity> getProcessesIdsToProcessesWithFields(@Nullable Set<String> var1, int var2, String ... var3);

    public long deleteProcessDefinitionsByKeys(Long ... var1);

    public ProcessInstanceForListViewEntity getProcessInstanceListViewByKey(Long var1);

    public Map<String, Long> getCoreStatistics(@Nullable Set<String> var1);

    public String getProcessInstanceTreePathById(String var1);

    public List<Map<String, String>> createCallHierarchyFor(List<String> var1, String var2);

    public long deleteDocument(String var1, String var2, String var3) throws IOException;

    public void deleteProcessInstanceFromTreePath(String var1);

    public List<ProcessInstanceForListViewEntity> getProcessInstancesByProcessAndStates(long var1, Set<ProcessInstanceState> var3, int var4, String[] var5);

    public List<ProcessInstanceForListViewEntity> getProcessInstancesByParentKeys(Set<Long> var1, int var2, String[] var3);

    public long deleteProcessInstancesAndDependants(Set<Long> var1);

    public static class ProcessKey {
        private String bpmnProcessId;
        private String tenantId;

        public ProcessKey(String bpmnProcessId, String tenantId) {
            this.bpmnProcessId = bpmnProcessId;
            this.tenantId = tenantId;
        }

        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        public ProcessKey setBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public ProcessKey setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.bpmnProcessId, this.tenantId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessKey that = (ProcessKey)o;
            return Objects.equals(this.bpmnProcessId, that.bpmnProcessId) && Objects.equals(this.tenantId, that.tenantId);
        }
    }
}

