/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.indices.MigrationRepositoryIndex;
import io.camunda.operate.schema.migration.BaseStepsRepository;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.schema.migration.StepsRepository;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchStepsRepository
extends BaseStepsRepository
implements StepsRepository {
    private static final String STEP_FILE_EXTENSION = ".json";
    private static final String DEFAULT_SCHEMA_CHANGE_FOLDER = "/schema/opensearch/change";
    private final RichOpenSearchClient richOpenSearchClient;
    private final ObjectMapper objectMapper;
    private final OperateProperties operateProperties;
    private final MigrationRepositoryIndex migrationRepositoryIndex;

    @Autowired
    public OpensearchStepsRepository(OperateProperties operateProperties, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper, RichOpenSearchClient richOpenSearchClient, MigrationRepositoryIndex migrationRepositoryIndex) {
        this.operateProperties = operateProperties;
        this.objectMapper = objectMapper;
        this.richOpenSearchClient = richOpenSearchClient;
        this.migrationRepositoryIndex = migrationRepositoryIndex;
    }

    private Step readStepFromFile(InputStream is) throws IOException {
        return (Step)this.objectMapper.readValue(is, Step.class);
    }

    protected String idFromStep(Step step) {
        return step.getVersion() + "-" + step.getOrder();
    }

    @Override
    public void save(Step step) throws MigrationException, IOException {
        boolean createdOrUpdated = this.richOpenSearchClient.doc().indexWithRetries(RequestDSL.indexRequestBuilder(this.getName()).id(this.idFromStep(step)).document((Object)step));
        if (!createdOrUpdated) {
            throw new MigrationException(String.format("Error in save step %s:  document wasn't created/updated.", step));
        }
        this.logger.info("Step {}  saved.", (Object)step);
    }

    @Override
    public List<Step> findAll() {
        this.logger.debug("Find all steps from Opensearch at {} ", (Object)this.operateProperties.getOpensearch().getUrl());
        return this.richOpenSearchClient.doc().searchValues(RequestDSL.searchRequestBuilder(this.getName()), Step.class);
    }

    @Override
    public List<Step> findNotAppliedFor(String indexName) {
        this.logger.debug("Find 'not applied steps' for index {} from Opensearch at {}", (Object)indexName, (Object)this.operateProperties.getOpensearch().getUrl());
        return this.richOpenSearchClient.doc().searchValues(RequestDSL.searchRequestBuilder(this.getName()).query(QueryDSL.and(QueryDSL.term("indexName.keyword", indexName), QueryDSL.term("applied", false))), Step.class);
    }

    @Override
    public String getName() {
        return this.migrationRepositoryIndex.getFullQualifiedName();
    }

    @Override
    public void refreshIndex() {
        this.richOpenSearchClient.index().refresh(this.getName());
    }

    @Override
    public List<Step> readStepsFromClasspath() throws IOException {
        ArrayList<Step> steps = new ArrayList<Step>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("/schema/opensearch/change/*.json")) {
                this.logger.info("Read step {} ", (Object)resource.getFilename());
                steps.add(this.readStepFromFile(resource.getInputStream()));
            }
            steps.sort(Step.SEMANTICVERSION_ORDER_COMPARATOR);
            return steps;
        }
        catch (FileNotFoundException ex) {
            this.logger.warn(String.format("Directory with migration steps was not found: %s", ex.getMessage()));
            return steps;
        }
    }
}

