/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.migration.FillPostImporterQueuePlan;
import io.camunda.operate.schema.migration.MigrationPlanFactory;
import io.camunda.operate.schema.migration.ReindexPlan;
import io.camunda.operate.schema.migration.ReindexWithQueryAndScriptPlan;
import io.camunda.operate.schema.opensearch.OpensearchFillPostImporterQueuePlan;
import io.camunda.operate.schema.opensearch.OpensearchPipelineReindexPlan;
import io.camunda.operate.schema.opensearch.OpensearchReindexWithQueryAndScriptPlan;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpensearchCondition.class})
public class OpensearchMigrationPlanFactory
implements MigrationPlanFactory {
    private final OperateProperties operateProperties;
    private final MigrationProperties migrationProperties;
    private final ObjectMapper objectMapper;
    private final RichOpenSearchClient richOpenSearchClient;

    @Autowired
    public OpensearchMigrationPlanFactory(OperateProperties operateProperties, MigrationProperties migrationProperties, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper, RichOpenSearchClient richOpenSearchClient) {
        this.operateProperties = operateProperties;
        this.migrationProperties = migrationProperties;
        this.objectMapper = objectMapper;
        this.richOpenSearchClient = richOpenSearchClient;
    }

    @Override
    public FillPostImporterQueuePlan createFillPostImporterQueuePlan() {
        return new OpensearchFillPostImporterQueuePlan(this.richOpenSearchClient, this.objectMapper, this.operateProperties, this.migrationProperties);
    }

    @Override
    public ReindexPlan createReindexPlan() {
        return new OpensearchPipelineReindexPlan(this.richOpenSearchClient, this.migrationProperties);
    }

    @Override
    public ReindexWithQueryAndScriptPlan createReindexWithQueryAndScriptPlan() {
        return new OpensearchReindexWithQueryAndScriptPlan(this.richOpenSearchClient, this.migrationProperties);
    }
}

