/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.post.PostImporterActionType;
import io.camunda.operate.entities.post.PostImporterQueueEntity;
import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.migration.FillPostImporterQueuePlan;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.LambdaExceptionUtil;
import java.time.OffsetDateTime;
import java.util.List;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class OpensearchFillPostImporterQueuePlan
implements FillPostImporterQueuePlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchFillPostImporterQueuePlan.class);
    private final OperateProperties operateProperties;
    private final MigrationProperties migrationProperties;
    private final ObjectMapper objectMapper;
    private final RichOpenSearchClient richOpenSearchClient;
    private Long flowNodesWithIncidentsCount;
    private List<Step> steps;
    private String listViewIndexName;
    private String incidentsIndexName;
    private String postImporterQueueIndexName;

    public OpensearchFillPostImporterQueuePlan(RichOpenSearchClient richOpenSearchClient, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper, OperateProperties operateProperties, MigrationProperties migrationProperties) {
        this.richOpenSearchClient = richOpenSearchClient;
        this.objectMapper = objectMapper;
        this.operateProperties = operateProperties;
        this.migrationProperties = migrationProperties;
    }

    @Override
    public FillPostImporterQueuePlan setListViewIndexName(String listViewIndexName) {
        this.listViewIndexName = listViewIndexName;
        return this;
    }

    @Override
    public FillPostImporterQueuePlan setIncidentsIndexName(String incidentsIndexName) {
        this.incidentsIndexName = incidentsIndexName;
        return this;
    }

    @Override
    public FillPostImporterQueuePlan setPostImporterQueueIndexName(String postImporterQueueIndexName) {
        this.postImporterQueueIndexName = postImporterQueueIndexName;
        return this;
    }

    @Override
    public FillPostImporterQueuePlan setSteps(List<Step> steps) {
        this.steps = steps;
        return this;
    }

    @Override
    public List<Step> getSteps() {
        return this.steps;
    }

    @Override
    public void executeOn(SchemaManager schemaManager) throws MigrationException {
        long srcCount = schemaManager.getNumberOfDocumentsFor(this.postImporterQueueIndexName);
        if (srcCount > 0L) {
            LOGGER.info("No migration needed for postImporterQueueIndex, already contains data.");
            return;
        }
        try {
            String incidentKeysFieldName = "incidentKeys";
            SearchRequest.Builder request = RequestDSL.searchRequestBuilder(this.listViewIndexName + "*").query(QueryDSL.and(QueryDSL.term("joinRelation", "activity"), QueryDSL.term("pendingIncident", true))).source(QueryDSL.sourceInclude("incidentKeys")).sort(QueryDSL.sortOptions("incidentKeys", SortOrder.Asc), new SortOptions[0]).size(Integer.valueOf(this.operateProperties.getOpensearch().getBatchSize()));
            this.richOpenSearchClient.doc().scrollWith(request, Long.class, LambdaExceptionUtil.rethrowConsumer(hits -> {
                List<IncidentEntity> incidents = this.getIncidentEntities("incidentKeys", (List<Hit<Long>>)hits);
                BatchRequest batchRequest = this.richOpenSearchClient.batch().newBatchRequest();
                int index = 0;
                for (IncidentEntity incident : incidents) {
                    PostImporterQueueEntity entity = this.createPostImporterQueueEntity(incident, ++index);
                    batchRequest.add(this.postImporterQueueIndexName, entity);
                }
                batchRequest.execute();
            }), hitsMetadata -> {
                if (this.flowNodesWithIncidentsCount == null) {
                    this.flowNodesWithIncidentsCount = hitsMetadata.total().value();
                }
            });
        }
        catch (Exception e) {
            throw new MigrationException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void validateMigrationResults(SchemaManager schemaManager) throws MigrationException {
        long dstCount = schemaManager.getNumberOfDocumentsFor(this.postImporterQueueIndexName);
        if (this.flowNodesWithIncidentsCount != null && this.flowNodesWithIncidentsCount > dstCount) {
            throw new MigrationException(String.format("Exception occurred when migrating %s. Number of flow nodes with pending incidents: %s, number of documents in post-importer-queue: %s", this.postImporterQueueIndexName, this.flowNodesWithIncidentsCount, dstCount));
        }
    }

    private List<IncidentEntity> getIncidentEntities(String incidentKeysFieldName, List<Hit<Long>> hits) {
        List<Long> incidentKeys = hits.stream().map(Hit::source).toList();
        SearchRequest.Builder request = RequestDSL.searchRequestBuilder(incidentKeysFieldName + "*").query(QueryDSL.longTerms("id", incidentKeys)).sort(QueryDSL.sortOptions("id", SortOrder.Asc), new SortOptions[0]).size(Integer.valueOf(this.operateProperties.getOpensearch().getBatchSize()));
        return this.richOpenSearchClient.doc().searchValues(request, IncidentEntity.class);
    }

    private PostImporterQueueEntity createPostImporterQueueEntity(IncidentEntity incident, long index) {
        return ((PostImporterQueueEntity)new PostImporterQueueEntity().setId(String.format("%s-%s", incident.getId(), incident.getState().getZeebeIntent()))).setCreationTime(OffsetDateTime.now()).setKey(incident.getKey()).setIntent(incident.getState().getZeebeIntent()).setPosition(index).setPartitionId(incident.getPartitionId()).setActionType(PostImporterActionType.INCIDENT).setProcessInstanceKey(incident.getProcessInstanceKey());
    }

    public String toString() {
        return "OpensearchFillPostImporterQueuePlan{listViewIndexName='" + this.listViewIndexName + "', incidentsIndexName='" + this.incidentsIndexName + "', postImporterQueueIndexName='" + this.postImporterQueueIndexName + "', operateProperties=" + String.valueOf(this.operateProperties) + ", migrationProperties=" + String.valueOf(this.migrationProperties) + ", objectMapper=" + String.valueOf(this.objectMapper) + ", flowNodesWithIncidentsCount=" + this.flowNodesWithIncidentsCount + "}";
    }
}

