/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.management;

import io.camunda.operate.management.IndicesCheck;
import io.camunda.operate.property.OperateProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component(value="indicesCheck")
public class IndicesHealthIndicator
implements HealthIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndicesHealthIndicator.class);
    private final IndicesCheck indicesCheck;
    private final OperateProperties properties;

    public IndicesHealthIndicator(IndicesCheck indicesCheck, OperateProperties operateProperties) {
        this.indicesCheck = indicesCheck;
        this.properties = operateProperties;
    }

    public Health getHealth(boolean includeDetails) {
        return this.health();
    }

    public Health health() {
        LOGGER.debug("Indices check is called");
        if (this.indicesCheck.isHealthy() && this.indicesCheck.indicesArePresent()) {
            return Health.up().build();
        }
        return Health.down().build();
    }
}

