/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.entities.dmn;

import io.camunda.operate.entities.FlowNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DecisionType {
    DECISION_TABLE,
    LITERAL_EXPRESSION,
    UNSPECIFIED,
    UNKNOWN;

    private static final Logger LOGGER;

    public static DecisionType fromZeebeDecisionType(String decisionType) {
        if (decisionType == null) {
            return UNSPECIFIED;
        }
        try {
            return DecisionType.valueOf(decisionType);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Decision type not found for value [{}]. UNKNOWN type will be assigned.", (Object)decisionType);
            return UNKNOWN;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(FlowNodeType.class);
    }
}

