/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.entities;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ListenerEventType {
    START,
    END,
    UNSPECIFIED;

    private static final Logger LOGGER;

    public static ListenerEventType fromZeebeListenerEventType(String listenerEventType) {
        if (listenerEventType == null) {
            LOGGER.warn("Listener event type is null. Setting it as {}.", (Object)UNSPECIFIED);
            return UNSPECIFIED;
        }
        try {
            return ListenerEventType.valueOf(listenerEventType);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unknown listener event type [{}]. Setting it as {}.", (Object)listenerEventType, (Object)UNSPECIFIED);
            return UNSPECIFIED;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ListenerEventType.class);
    }
}

