/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.processors.fni;

import io.camunda.operate.entities.FlowNodeInstanceEntity;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.util.DateUtil;
import io.camunda.operate.zeebeimport.cache.FNITreePathCacheCompositeKey;
import io.camunda.operate.zeebeimport.cache.TreePathCache;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import java.time.Instant;
import java.util.Set;

public class FNITransformer {
    private static final Set<String> FINISH_STATES = Set.of(ProcessInstanceIntent.ELEMENT_COMPLETED.name(), ProcessInstanceIntent.ELEMENT_TERMINATED.name());
    private static final Set<String> START_STATES = Set.of(ProcessInstanceIntent.ELEMENT_ACTIVATING.name());
    private static final Set<BpmnElementType> CONTAINER_TYPES = Set.of(BpmnElementType.SUB_PROCESS, BpmnElementType.EVENT_SUB_PROCESS, BpmnElementType.MULTI_INSTANCE_BODY, BpmnElementType.PROCESS);
    private final TreePathCache treePathCache;

    public FNITransformer(TreePathCache treePathCache) {
        this.treePathCache = treePathCache;
    }

    private static FNITreePathCacheCompositeKey toCompositeKey(Record<?> record, ProcessInstanceRecordValue recordValue) {
        return new FNITreePathCacheCompositeKey(record.getPartitionId(), record.getKey(), recordValue.getFlowScopeKey(), recordValue.getProcessInstanceKey());
    }

    public FlowNodeInstanceEntity toFlowNodeInstanceEntity(Record<ProcessInstanceRecordValue> record, FlowNodeInstanceEntity entity) {
        if (entity == null) {
            entity = new FlowNodeInstanceEntity();
        }
        ProcessInstanceRecordValue recordValue = (ProcessInstanceRecordValue)record.getValue();
        String intentStr = record.getIntent().name();
        entity.setKey(record.getKey());
        entity.setId(ConversionUtils.toStringOrNull((Object)record.getKey()));
        entity.setPartitionId(record.getPartitionId());
        entity.setFlowNodeId(recordValue.getElementId());
        entity.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
        entity.setProcessDefinitionKey(Long.valueOf(recordValue.getProcessDefinitionKey()));
        entity.setBpmnProcessId(recordValue.getBpmnProcessId());
        entity.setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
        if (FINISH_STATES.contains(intentStr)) {
            if (intentStr.equals(ProcessInstanceIntent.ELEMENT_TERMINATED.name())) {
                entity.setState(FlowNodeState.TERMINATED);
            } else {
                entity.setState(FlowNodeState.COMPLETED);
            }
            entity.setEndDate(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
        } else {
            entity.setState(FlowNodeState.ACTIVE);
            if (START_STATES.contains(intentStr)) {
                entity.setStartDate(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                entity.setPosition(Long.valueOf(record.getPosition()));
            }
            if (entity.getTreePath() == null) {
                FNITreePathCacheCompositeKey compositeKey = FNITransformer.toCompositeKey(record, recordValue);
                String parentTreePath = this.treePathCache.resolveParentTreePath(compositeKey);
                String treePath = String.join((CharSequence)"/", parentTreePath, ConversionUtils.toStringOrNull((Object)record.getKey()));
                entity.setTreePath(treePath);
                entity.setLevel(parentTreePath.split("/").length);
                if (CONTAINER_TYPES.contains(recordValue.getBpmnElementType())) {
                    this.treePathCache.cacheTreePath(compositeKey, treePath);
                }
            }
        }
        entity.setType(FlowNodeType.fromZeebeBpmnElementType(recordValue.getBpmnElementType() == null ? null : recordValue.getBpmnElementType().name()));
        return entity;
    }
}

