/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.processors;

import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.indices.ProcessIndex;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.ListViewStore;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.operate.zeebeimport.util.XMLUtil;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessZeebeRecordProcessor.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Set<String> STATES = new HashSet<String>();
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private ListViewStore listViewStore;
    @Autowired
    private ProcessIndex processIndex;
    @Autowired
    private XMLUtil xmlUtil;

    public void processDeploymentRecord(Record record, BatchRequest batchRequest) throws PersistenceException {
        String intentStr = record.getIntent().name();
        if (STATES.contains(intentStr)) {
            ProcessMetadataValue recordValue = (ProcessMetadataValue)record.getValue();
            this.persistProcess((Process)recordValue, batchRequest);
        }
    }

    private void persistProcess(Process process, BatchRequest batchRequest) throws PersistenceException {
        ProcessEntity processEntity = this.createEntity(process);
        LOGGER.debug("Process: key {}, bpmnProcessId {}", (Object)processEntity.getKey(), (Object)processEntity.getBpmnProcessId());
        this.updateFieldsInInstancesFor(processEntity, batchRequest);
        batchRequest.addWithId(this.processIndex.getFullQualifiedName(), ConversionUtils.toStringOrNull((Object)processEntity.getKey()), (OperateEntity)processEntity);
    }

    private void updateFieldsInInstancesFor(ProcessEntity processEntity, BatchRequest batchRequest) throws PersistenceException {
        List processInstanceKeys = this.listViewStore.getProcessInstanceKeysWithEmptyProcessVersionFor(Long.valueOf(processEntity.getKey()));
        for (Long processInstanceKey : processInstanceKeys) {
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("processName", processEntity.getName());
            updateFields.put("processVersion", processEntity.getVersion());
            updateFields.put("processVersionTag", processEntity.getVersion());
            batchRequest.update(this.listViewTemplate.getFullQualifiedName(), processInstanceKey.toString(), updateFields);
        }
    }

    private ProcessEntity createEntity(Process process) {
        Optional diagramData;
        ProcessEntity processEntity = ((ProcessEntity)new ProcessEntity().setId(String.valueOf(process.getProcessDefinitionKey())).setKey(process.getProcessDefinitionKey())).setBpmnProcessId(process.getBpmnProcessId()).setVersion(process.getVersion()).setTenantId(ImportUtil.tenantOrDefault((String)process.getTenantId()));
        byte[] byteArray = process.getResource();
        String bpmn = new String(byteArray, CHARSET);
        processEntity.setBpmnXml(bpmn);
        String resourceName = process.getResourceName();
        processEntity.setResourceName(resourceName);
        if (!process.getVersionTag().isEmpty()) {
            processEntity.setVersionTag(process.getVersionTag());
        }
        if ((diagramData = this.xmlUtil.extractDiagramData(byteArray, process.getBpmnProcessId())).isPresent()) {
            processEntity.setName(((ProcessEntity)diagramData.get()).getName()).setFlowNodes(((ProcessEntity)diagramData.get()).getFlowNodes());
        }
        return processEntity;
    }

    static {
        STATES.add(ProcessIntent.CREATED.name());
    }
}

