/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.processors;

import io.camunda.operate.entities.JobEntity;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.JobTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.util.DateUtil;
import io.camunda.operate.util.LambdaExceptionUtil;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobZeebeRecordProcessor.class);
    private static final Set<String> JOB_EVENTS = new HashSet<String>();
    private static final Set<String> FAILED_JOB_EVENTS = new HashSet<String>();
    @Autowired
    private JobTemplate jobTemplate;

    public void processJobRecords(Map<Long, List<Record<JobRecordValue>>> records, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        LOGGER.debug("Importing Job records.");
        for (List<Record<JobRecordValue>> flowNodeJobRecords : records.values()) {
            Map<Long, List<Record>> groupedByJobKey = flowNodeJobRecords.stream().collect(Collectors.groupingBy(jobRecord -> jobRecord.getKey()));
            for (List<Record<JobRecordValue>> list : groupedByJobKey.values()) {
                this.processLastRecord(list, JOB_EVENTS, LambdaExceptionUtil.rethrowConsumer(record -> {
                    JobRecordValue recordValue = (JobRecordValue)record.getValue();
                    this.processJob((Record)record, recordValue, batchRequest, concurrencyMode);
                }));
            }
        }
    }

    private <T extends RecordValue> void processLastRecord(List<Record<JobRecordValue>> records, Set<String> events, Consumer<Record<? extends RecordValue>> recordProcessor) {
        if (records.size() >= 1) {
            for (int i = records.size() - 1; i >= 0; --i) {
                String intentStr = records.get(i).getIntent().name();
                if (!events.contains(intentStr)) continue;
                if (i > 0 && FAILED_JOB_EVENTS.contains(intentStr)) {
                    recordProcessor.accept(records.get(i - 1));
                }
                recordProcessor.accept(records.get(i));
                break;
            }
        }
    }

    private void processJob(Record record, JobRecordValue recordValue, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        long jobDeadline;
        JobEntity jobEntity = ((JobEntity)((JobEntity)((JobEntity)new JobEntity().setId(Long.toString(record.getKey()))).setKey(record.getKey())).setPartitionId(record.getPartitionId())).setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey())).setFlowNodeInstanceId(Long.valueOf(recordValue.getElementInstanceKey())).setTenantId(recordValue.getTenantId()).setType(recordValue.getType()).setWorker(recordValue.getWorker()).setState(record.getIntent().name()).setRetries(Integer.valueOf(recordValue.getRetries())).setErrorMessage(recordValue.getErrorMessage()).setErrorCode(recordValue.getErrorCode()).setEndTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp()))).setCustomHeaders(recordValue.getCustomHeaders()).setJobKind(recordValue.getJobKind().name()).setFlowNodeId(recordValue.getElementId());
        if (recordValue.getJobListenerEventType() != null) {
            jobEntity.setListenerEventType(recordValue.getJobListenerEventType().name());
        }
        if ((jobDeadline = recordValue.getDeadline()) >= 0L) {
            jobEntity.setDeadline(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(jobDeadline)));
        }
        if (FAILED_JOB_EVENTS.contains(record.getIntent().name())) {
            jobEntity.setFlowNodeId(null);
            if (recordValue.getRetries() > 0) {
                jobEntity.setJobFailedWithRetriesLeft(true);
            } else {
                jobEntity.setJobFailedWithRetriesLeft(false);
            }
        }
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        updateFields.put("flowNodeId", jobEntity.getFlowNodeId());
        updateFields.put("worker", jobEntity.getWorker());
        updateFields.put("state", jobEntity.getState());
        updateFields.put("retries", jobEntity.getRetries());
        updateFields.put("errorMessage", jobEntity.getErrorMessage());
        updateFields.put("errorCode", jobEntity.getErrorCode());
        updateFields.put("endTime", jobEntity.getEndTime());
        updateFields.put("customHeaders", jobEntity.getCustomHeaders());
        updateFields.put("deadline", jobEntity.getDeadline());
        batchRequest.upsertWithScript(this.jobTemplate.getFullQualifiedName(), jobEntity.getId(), (OperateEntity)jobEntity, this.getJobUpdateScript(), updateFields);
    }

    private String getJobUpdateScript() {
        return String.format("if (ctx._source.%s == null || ctx._source.%s < params.%s) { ctx._source.%s = params.%s; if (params.%s != null) {   ctx._source.%s = params.%s; }ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; if (params.%s != null) {   ctx._source.%s = params.%s;    ctx._source.%s = params.%s; }if (params.%s != null) { ctx._source.%s = params.%s; }if (params.%s != null) { ctx._source.%s = params.%s; }if (params.%s != null) { ctx._source.%s = params.%s; }}", "position", "position", "position", "position", "position", "flowNodeId", "flowNodeId", "flowNodeId", "state", "state", "retries", "retries", "worker", "worker", "errorMessage", "errorMessage", "errorMessage", "errorCode", "errorCode", "endTime", "endTime", "endTime", "customHeaders", "customHeaders", "customHeaders", "deadline", "deadline", "deadline");
    }

    static {
        JOB_EVENTS.add(JobIntent.CREATED.name());
        JOB_EVENTS.add(JobIntent.COMPLETED.name());
        JOB_EVENTS.add(JobIntent.TIMED_OUT.name());
        JOB_EVENTS.add(JobIntent.FAILED.name());
        JOB_EVENTS.add(JobIntent.RETRIES_UPDATED.name());
        JOB_EVENTS.add(JobIntent.CANCELED.name());
        JOB_EVENTS.add(JobIntent.ERROR_THROWN.name());
        JOB_EVENTS.add(JobIntent.MIGRATED.name());
        FAILED_JOB_EVENTS.add(JobIntent.FAILED.name());
        FAILED_JOB_EVENTS.add(JobIntent.ERROR_THROWN.name());
    }
}

