/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.processors;

import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.dmn.definition.DecisionRequirementsEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.indices.DecisionRequirementsIndex;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsRecordValue;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DecisionRequirementsZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionRequirementsZeebeRecordProcessor.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Set<String> STATES = new HashSet<String>();
    @Autowired
    private DecisionRequirementsIndex decisionRequirementsIndex;

    public void processDecisionRequirementsRecord(Record record, BatchRequest batchRequest) throws PersistenceException {
        String intentStr = record.getIntent().name();
        if (STATES.contains(intentStr)) {
            DecisionRequirementsRecordValue decisionRequirements = (DecisionRequirementsRecordValue)record.getValue();
            this.persistDecisionRequirements(decisionRequirements, batchRequest);
        }
    }

    private void persistDecisionRequirements(DecisionRequirementsRecordValue decision, BatchRequest batchRequest) throws PersistenceException {
        DecisionRequirementsEntity decisionReqEntity = this.createEntity(decision);
        LOGGER.debug("Process: key {}, decisionRequirementsId {}", (Object)decisionReqEntity.getKey(), (Object)decisionReqEntity.getDecisionRequirementsId());
        batchRequest.addWithId(this.decisionRequirementsIndex.getFullQualifiedName(), ConversionUtils.toStringOrNull((Object)decisionReqEntity.getKey()), (OperateEntity)decisionReqEntity);
    }

    private DecisionRequirementsEntity createEntity(DecisionRequirementsRecordValue decisionRequirements) {
        byte[] byteArray = decisionRequirements.getResource();
        String dmn = new String(byteArray, CHARSET);
        return ((DecisionRequirementsEntity)((DecisionRequirementsEntity)new DecisionRequirementsEntity().setId(String.valueOf(decisionRequirements.getDecisionRequirementsKey()))).setKey(decisionRequirements.getDecisionRequirementsKey())).setName(decisionRequirements.getDecisionRequirementsName()).setDecisionRequirementsId(decisionRequirements.getDecisionRequirementsId()).setVersion(decisionRequirements.getDecisionRequirementsVersion()).setResourceName(decisionRequirements.getResourceName()).setXml(dmn).setTenantId(ImportUtil.tenantOrDefault((String)decisionRequirements.getTenantId()));
    }

    static {
        STATES.add(ProcessIntent.CREATED.name());
    }
}

