/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.v8_5.processors;

import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.VariableEntity;
import io.camunda.operate.entities.listview.VariableForListViewEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.VariableTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.util.Tuple;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.v850.record.Record;
import io.camunda.zeebe.protocol.v850.record.intent.Intent;
import io.camunda.zeebe.protocol.v850.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.v850.record.value.VariableRecordValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VariableZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableZeebeRecordProcessor.class);
    @Autowired
    private VariableTemplate variableTemplate;
    @Autowired
    private OperateProperties operateProperties;

    public void processVariableRecords(Map<Long, List<Record<VariableRecordValue>>> variablesGroupedByScopeKey, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        for (Map.Entry<Long, List<Record<VariableRecordValue>>> variableRecords : variablesGroupedByScopeKey.entrySet()) {
            HashMap<String, Tuple> temporaryVariableCache = new HashMap<String, Tuple>();
            List<Record<VariableRecordValue>> scopedVariables = variableRecords.getValue();
            for (Record<VariableRecordValue> scopedVariable : scopedVariables) {
                Intent intent = scopedVariable.getIntent();
                VariableRecordValue variableValue = scopedVariable.getValue();
                String variableName = variableValue.getName();
                Tuple cachedVariable = temporaryVariableCache.computeIfAbsent(variableName, k -> Tuple.of((Object)intent, (Object)new VariableEntity()));
                VariableEntity variableEntity = (VariableEntity)cachedVariable.getRight();
                this.processVariableRecord(scopedVariable, variableEntity);
            }
            for (Tuple cachedVariable : temporaryVariableCache.values()) {
                Intent initialIntent = (Intent)cachedVariable.getLeft();
                VariableEntity variableEntity = (VariableEntity)cachedVariable.getRight();
                LOGGER.debug("Variable instance: id {}", (Object)variableEntity.getId());
                HashMap<String, Object> updateFields = new HashMap<String, Object>();
                updateFields.put("position", variableEntity.getPosition());
                if (initialIntent == VariableIntent.MIGRATED) {
                    updateFields.put("processDefinitionKey", variableEntity.getProcessDefinitionKey());
                    updateFields.put("bpmnProcessId", variableEntity.getBpmnProcessId());
                } else {
                    updateFields.put("value", variableEntity.getValue());
                    updateFields.put("fullValue", variableEntity.getFullValue());
                    updateFields.put("isPreview", variableEntity.getIsPreview());
                    updateFields.put("processDefinitionKey", variableEntity.getProcessDefinitionKey());
                    updateFields.put("bpmnProcessId", variableEntity.getBpmnProcessId());
                }
                if (concurrencyMode) {
                    batchRequest.upsertWithScript(this.variableTemplate.getFullQualifiedName(), variableEntity.getId(), (OperateEntity)variableEntity, this.getScript(), updateFields);
                    continue;
                }
                batchRequest.upsert(this.variableTemplate.getFullQualifiedName(), variableEntity.getId(), (OperateEntity)variableEntity, updateFields);
            }
        }
    }

    private String getScript() {
        return String.format("if (ctx._source.%s == null || ctx._source.%s < params.%s) { ctx._source.%s = params.%s; if (params.%s != null) {   ctx._source.%s = params.%s;    ctx._source.%s = params.%s;    ctx._source.%s = params.%s; }if (params.%s != null) {   ctx._source.%s = params.%s;    ctx._source.%s = params.%s; }}", "position", "position", "position", "position", "position", "varValue", "varValue", "fullValue", "fullValue", "isPreview", "isPreview", "processDefinitionKey", "processDefinitionKey", "bpmnProcessId", "bpmnProcessId");
    }

    private void processVariableRecord(Record<VariableRecordValue> record, VariableEntity entity) {
        VariableRecordValue recordValue = record.getValue();
        ((VariableEntity)((VariableEntity)((VariableEntity)entity.setId(VariableForListViewEntity.getIdBy((long)recordValue.getScopeKey(), (String)recordValue.getName()))).setKey(record.getKey())).setPartitionId(record.getPartitionId())).setScopeKey(Long.valueOf(recordValue.getScopeKey())).setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey())).setProcessDefinitionKey(Long.valueOf(recordValue.getProcessDefinitionKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setName(recordValue.getName()).setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId())).setPosition(Long.valueOf(record.getPosition()));
        if (recordValue.getValue().length() > this.operateProperties.getImporter().getVariableSizeThreshold()) {
            entity.setValue(recordValue.getValue().substring(0, this.operateProperties.getImporter().getVariableSizeThreshold()));
            entity.setFullValue(recordValue.getValue());
            entity.setIsPreview(true);
        } else {
            entity.setValue(recordValue.getValue());
            entity.setFullValue(null);
            entity.setIsPreview(false);
        }
    }
}

