/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.v8_5.processors;

import io.camunda.operate.cache.ProcessCache;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.entities.listview.FlowNodeInstanceForListViewEntity;
import io.camunda.operate.entities.listview.ProcessInstanceForListViewEntity;
import io.camunda.operate.entities.listview.ProcessInstanceState;
import io.camunda.operate.entities.listview.VariableForListViewEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.FlowNodeStore;
import io.camunda.operate.store.ListViewStore;
import io.camunda.operate.store.MetricsStore;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.util.DateUtil;
import io.camunda.operate.util.LambdaExceptionUtil;
import io.camunda.operate.util.OperationsManager;
import io.camunda.operate.util.SoftHashMap;
import io.camunda.operate.util.TreePath;
import io.camunda.operate.util.Tuple;
import io.camunda.operate.zeebe.PartitionHolder;
import io.camunda.operate.zeebeimport.ImportBatch;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.v850.record.Record;
import io.camunda.zeebe.protocol.v850.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.v850.record.intent.Intent;
import io.camunda.zeebe.protocol.v850.record.intent.JobIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.v850.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.v850.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.v850.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.v850.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.v850.record.value.VariableRecordValue;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ListViewZeebeRecordProcessor {
    protected static final int EMPTY_PARENT_PROCESS_INSTANCE_ID = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(ListViewZeebeRecordProcessor.class);
    private static final Set<String> PI_AND_AI_START_STATES = new HashSet<String>();
    private static final Set<String> PI_AND_AI_FINISH_STATES = new HashSet<String>();
    private static final Set<String> FAILED_JOB_EVENTS = new HashSet<String>();
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private ProcessCache processCache;
    @Autowired
    private OperationsManager operationsManager;
    @Autowired
    private ListViewStore listViewStore;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private PartitionHolder partitionHolder;
    @Autowired
    private FlowNodeStore flowNodeStore;
    @Autowired
    private MetricsStore metricsStore;
    private Map<String, String> treePathCache;
    private Map<String, String> callActivityIdCache;

    private Map<String, String> getTreePathCache() {
        if (this.treePathCache == null) {
            this.treePathCache = new SoftHashMap(this.operateProperties.getElasticsearch().getBatchSize() * this.partitionHolder.getPartitionIds().size());
        }
        return this.treePathCache;
    }

    private Map<String, String> getCallActivityIdCache() {
        if (this.callActivityIdCache == null) {
            this.callActivityIdCache = new SoftHashMap(this.operateProperties.getElasticsearch().getBatchSize() * this.partitionHolder.getPartitionIds().size());
        }
        return this.callActivityIdCache;
    }

    public void processIncidentRecord(Record record, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        String intentStr = record.getIntent().name();
        IncidentRecordValue recordValue = (IncidentRecordValue)record.getValue();
        FlowNodeInstanceForListViewEntity entity = new FlowNodeInstanceForListViewEntity();
        entity.setId(ConversionUtils.toStringOrNull((Object)recordValue.getElementInstanceKey()));
        entity.setKey(recordValue.getElementInstanceKey());
        entity.setPartitionId(record.getPartitionId());
        entity.setPositionIncident(Long.valueOf(record.getPosition()));
        entity.setActivityId(recordValue.getElementId());
        entity.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
        entity.setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
        if (intentStr.equals(IncidentIntent.CREATED.name())) {
            entity.setErrorMessage(StringUtils.trimWhitespace((String)recordValue.getErrorMessage()));
        } else if (intentStr.equals(IncidentIntent.RESOLVED.name())) {
            entity.setErrorMessage(null);
        }
        Long processInstanceKey = recordValue.getProcessInstanceKey();
        entity.getJoinRelation().setParent(processInstanceKey);
        LOGGER.debug("Activity instance for list view: id {}", (Object)entity.getId());
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        updateFields.put("errorMessage", entity.getErrorMessage());
        updateFields.put("positionIncident", entity.getPositionIncident());
        if (concurrencyMode) {
            batchRequest.upsertWithScriptAndRouting(this.listViewTemplate.getFullQualifiedName(), entity.getId(), (OperateEntity)entity, this.getIncidentScript(), updateFields, String.valueOf(processInstanceKey));
        } else {
            batchRequest.upsertWithRouting(this.listViewTemplate.getFullQualifiedName(), entity.getId(), (OperateEntity)entity, updateFields, processInstanceKey.toString());
        }
    }

    public void processVariableRecords(Map<Long, List<Record<VariableRecordValue>>> variablesGroupedByScopeKey, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        for (Map.Entry<Long, List<Record<VariableRecordValue>>> variableRecords : variablesGroupedByScopeKey.entrySet()) {
            HashMap<String, Tuple> temporaryVariableCache = new HashMap<String, Tuple>();
            List<Record<VariableRecordValue>> scopedVariables = variableRecords.getValue();
            for (Record<VariableRecordValue> scopedVariable : scopedVariables) {
                Intent intent = scopedVariable.getIntent();
                VariableRecordValue variableValue = scopedVariable.getValue();
                String variableName = variableValue.getName();
                Tuple cachedVariable = temporaryVariableCache.computeIfAbsent(variableName, k -> Tuple.of((Object)intent, (Object)new VariableForListViewEntity()));
                VariableForListViewEntity variableEntity = (VariableForListViewEntity)cachedVariable.getRight();
                this.processVariableRecord(scopedVariable, variableEntity);
            }
            for (Tuple cachedVariable : temporaryVariableCache.values()) {
                Intent initialIntent = (Intent)cachedVariable.getLeft();
                VariableForListViewEntity variableEntity = (VariableForListViewEntity)cachedVariable.getRight();
                LOGGER.debug("Variable for list view: id {}", (Object)variableEntity.getId());
                Long processInstanceKey = variableEntity.getProcessInstanceKey();
                HashMap<String, Object> updateFields = new HashMap<String, Object>();
                updateFields.put("varName", variableEntity.getVarName());
                updateFields.put("varValue", variableEntity.getVarValue());
                updateFields.put("position", variableEntity.getPosition());
                if (concurrencyMode) {
                    batchRequest.upsertWithScriptAndRouting(this.listViewTemplate.getFullQualifiedName(), variableEntity.getId(), (OperateEntity)variableEntity, this.getVariableScript(), updateFields, String.valueOf(processInstanceKey));
                    continue;
                }
                batchRequest.upsertWithRouting(this.listViewTemplate.getFullQualifiedName(), variableEntity.getId(), (OperateEntity)variableEntity, updateFields, processInstanceKey.toString());
            }
        }
    }

    public void processProcessInstanceRecord(Map<Long, List<Record<ProcessInstanceRecordValue>>> records, BatchRequest batchRequest, ImportBatch importBatch, boolean concurrencyMode) throws PersistenceException {
        HashMap<String, String> treePathMap = new HashMap<String, String>();
        for (Map.Entry<Long, List<Record<ProcessInstanceRecordValue>>> wiRecordsEntry : records.entrySet()) {
            ProcessInstanceForListViewEntity piEntity = null;
            HashMap<Long, FlowNodeInstanceForListViewEntity> actEntities = new HashMap<Long, FlowNodeInstanceForListViewEntity>();
            Long processInstanceKey = wiRecordsEntry.getKey();
            for (Record<ProcessInstanceRecordValue> record : wiRecordsEntry.getValue()) {
                if (!this.shouldProcessProcessInstanceRecord(record)) continue;
                ProcessInstanceRecordValue recordValue = record.getValue();
                if (this.isProcessEvent(recordValue)) {
                    if (this.isProcessInstanceTerminated(record)) {
                        this.operationsManager.completeOperation(null, Long.valueOf(record.getKey()), null, OperationType.CANCEL_PROCESS_INSTANCE, batchRequest);
                    } else if (this.isProcessInstanceMigrated(record)) {
                        this.operationsManager.completeOperation(null, Long.valueOf(record.getKey()), null, OperationType.MIGRATE_PROCESS_INSTANCE, batchRequest);
                    }
                    piEntity = this.updateProcessInstance(importBatch, record, piEntity, treePathMap, batchRequest);
                    continue;
                }
                this.updateFlowNodeInstance(record, actEntities);
            }
            if (piEntity != null) {
                LOGGER.debug("Process instance for list view: id {}", (Object)piEntity.getId());
                HashMap<String, Object> updateFields = new HashMap<String, Object>();
                if (piEntity.getStartDate() != null) {
                    updateFields.put("startDate", piEntity.getStartDate());
                }
                if (piEntity.getEndDate() != null) {
                    updateFields.put("endDate", piEntity.getEndDate());
                }
                updateFields.put("processName", piEntity.getProcessName());
                updateFields.put("processVersion", piEntity.getProcessVersion());
                updateFields.put("processDefinitionKey", piEntity.getProcessDefinitionKey());
                updateFields.put("bpmnProcessId", piEntity.getBpmnProcessId());
                updateFields.put("position", piEntity.getPosition());
                if (piEntity.getState() != null) {
                    updateFields.put("state", piEntity.getState());
                }
                if (concurrencyMode) {
                    batchRequest.upsertWithScriptAndRouting(this.listViewTemplate.getFullQualifiedName(), piEntity.getId(), (OperateEntity)piEntity, this.getProcessInstanceScript(), updateFields, String.valueOf(piEntity.getProcessInstanceKey()));
                } else {
                    batchRequest.upsert(this.listViewTemplate.getFullQualifiedName(), piEntity.getId(), (OperateEntity)piEntity, updateFields);
                }
            }
            for (FlowNodeInstanceForListViewEntity actEntity : actEntities.values()) {
                LOGGER.debug("Flow node instance for list view: id {}", (Object)actEntity.getId());
                HashMap<String, Object> updateFields = new HashMap<String, Object>();
                updateFields.put("position", actEntity.getPosition());
                updateFields.put("activityId", actEntity.getActivityId());
                updateFields.put("activityType", actEntity.getActivityType());
                updateFields.put("activityState", actEntity.getActivityState());
                if (concurrencyMode) {
                    batchRequest.upsertWithScriptAndRouting(this.listViewTemplate.getFullQualifiedName(), actEntity.getId(), (OperateEntity)actEntity, this.getFlowNodeInstanceScript(), updateFields, processInstanceKey.toString());
                    continue;
                }
                batchRequest.upsertWithRouting(this.listViewTemplate.getFullQualifiedName(), actEntity.getId(), (OperateEntity)actEntity, updateFields, processInstanceKey.toString());
            }
        }
    }

    private String getVariableScript() {
        return String.format("if (ctx._source.%s == null || ctx._source.%s < params.%s) { ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; }", "position", "position", "position", "position", "position", "varName", "varName", "varValue", "varValue");
    }

    private String getFlowNodeInstanceFromJobScript() {
        return String.format("if (ctx._source.%s == null || ctx._source.%s < params.%s) { ctx._source.%s = params.%s; ctx._source.%s = params.%s; }", "positionJob", "positionJob", "positionJob", "positionJob", "positionJob", "jobFailedWithRetriesLeft", "jobFailedWithRetriesLeft");
    }

    private String getFlowNodeInstanceScript() {
        return String.format("if (ctx._source.%s == null || ctx._source.%s < params.%s) { ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; }", "position", "position", "position", "position", "position", "activityId", "activityId", "activityType", "activityType", "activityState", "activityState");
    }

    private String getIncidentScript() {
        return String.format("if (ctx._source.%s == null || ctx._source.%s < params.%s) { ctx._source.%s = params.%s; ctx._source.%s = params.%s; }", "positionIncident", "positionIncident", "positionIncident", "positionIncident", "positionIncident", "errorMessage", "errorMessage");
    }

    private String getProcessInstanceScript() {
        return String.format("if (ctx._source.%s == null || ctx._source.%s < params.%s) { ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; if (params.%s != null) { ctx._source.%s = params.%s; }if (params.%s != null) { ctx._source.%s = params.%s; }if (params.%s != null) { ctx._source.%s = params.%s; }}", "position", "position", "position", "position", "position", "processName", "processName", "processVersion", "processVersion", "processDefinitionKey", "processDefinitionKey", "bpmnProcessId", "bpmnProcessId", "startDate", "startDate", "startDate", "endDate", "endDate", "endDate", "state", "state", "state");
    }

    public void processJobRecords(Map<Long, List<Record<JobRecordValue>>> records, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        for (List<Record<JobRecordValue>> jobRecords : records.values()) {
            this.processLastRecord(jobRecords, LambdaExceptionUtil.rethrowConsumer(record -> this.updateFlowNodeInstanceFromJob((Record<JobRecordValue>)record, batchRequest, concurrencyMode)));
        }
    }

    private void processLastRecord(List<Record<JobRecordValue>> records, Consumer<Record<JobRecordValue>> recordProcessor) {
        if (!records.isEmpty()) {
            recordProcessor.accept(records.get(records.size() - 1));
        }
    }

    private boolean shouldProcessProcessInstanceRecord(Record<ProcessInstanceRecordValue> record) {
        String intent = record.getIntent().name();
        return PI_AND_AI_START_STATES.contains(intent) || PI_AND_AI_FINISH_STATES.contains(intent) || ProcessInstanceIntent.ELEMENT_MIGRATED.name().equals(intent);
    }

    private boolean isProcessInstanceTerminated(Record<ProcessInstanceRecordValue> record) {
        return record.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATED;
    }

    private boolean isProcessInstanceMigrated(Record<ProcessInstanceRecordValue> record) {
        return record.getIntent() == ProcessInstanceIntent.ELEMENT_MIGRATED;
    }

    private ProcessInstanceForListViewEntity updateProcessInstance(ImportBatch importBatch, Record<ProcessInstanceRecordValue> record, ProcessInstanceForListViewEntity piEntity, Map<String, String> treePathMap, BatchRequest batchRequest) throws PersistenceException {
        String treePath;
        boolean isRootProcessInstance;
        if (piEntity == null) {
            piEntity = new ProcessInstanceForListViewEntity();
        }
        ProcessInstanceRecordValue recordValue = record.getValue();
        String intentStr = record.getIntent().name();
        ((ProcessInstanceForListViewEntity)((ProcessInstanceForListViewEntity)((ProcessInstanceForListViewEntity)piEntity.setId(String.valueOf(recordValue.getProcessInstanceKey()))).setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey())).setKey(recordValue.getProcessInstanceKey())).setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId())).setPartitionId(record.getPartitionId())).setPosition(Long.valueOf(record.getPosition())).setProcessDefinitionKey(Long.valueOf(recordValue.getProcessDefinitionKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setProcessVersion(Integer.valueOf(recordValue.getVersion())).setProcessName(this.processCache.getProcessNameOrDefaultValue(piEntity.getProcessDefinitionKey(), recordValue.getBpmnProcessId()));
        OffsetDateTime timestamp = DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp()));
        boolean bl = isRootProcessInstance = recordValue.getParentProcessInstanceKey() == -1L;
        if (intentStr.equals(ProcessInstanceIntent.ELEMENT_COMPLETED.name()) || intentStr.equals(ProcessInstanceIntent.ELEMENT_TERMINATED.name())) {
            importBatch.incrementFinishedWiCount();
            piEntity.setEndDate(timestamp);
            if (intentStr.equals(ProcessInstanceIntent.ELEMENT_TERMINATED.name())) {
                piEntity.setState(ProcessInstanceState.CANCELED);
            } else {
                piEntity.setState(ProcessInstanceState.COMPLETED);
            }
        } else if (intentStr.equals(ProcessInstanceIntent.ELEMENT_ACTIVATING.name())) {
            piEntity.setStartDate(timestamp).setState(ProcessInstanceState.ACTIVE);
            if (isRootProcessInstance) {
                this.registerStartedRootProcessInstance(piEntity, batchRequest, timestamp);
            }
        } else {
            piEntity.setState(ProcessInstanceState.ACTIVE);
        }
        if (!isRootProcessInstance) {
            piEntity.setParentProcessInstanceKey(Long.valueOf(recordValue.getParentProcessInstanceKey())).setParentFlowNodeInstanceKey(Long.valueOf(recordValue.getParentElementInstanceKey()));
            if (piEntity.getTreePath() == null) {
                treePath = this.getTreePathForCalledProcess(recordValue);
                piEntity.setTreePath(treePath);
                treePathMap.put(String.valueOf(record.getKey()), treePath);
            }
        }
        if (piEntity.getTreePath() == null) {
            treePath = new TreePath().startTreePath(ConversionUtils.toStringOrNull((Object)recordValue.getProcessInstanceKey())).toString();
            piEntity.setTreePath(treePath);
            this.getTreePathCache().put(ConversionUtils.toStringOrNull((Object)recordValue.getProcessInstanceKey()), treePath);
        }
        return piEntity;
    }

    private void registerStartedRootProcessInstance(ProcessInstanceForListViewEntity piEntity, BatchRequest batchRequest, OffsetDateTime timestamp) throws PersistenceException {
        String processInstanceKey = String.valueOf(piEntity.getProcessInstanceKey());
        this.metricsStore.registerProcessInstanceStartEvent(processInstanceKey, piEntity.getTenantId(), timestamp, batchRequest);
    }

    private String getTreePathForCalledProcess(ProcessInstanceRecordValue recordValue) {
        String parentTreePath = null;
        if (this.getTreePathCache().get(ConversionUtils.toStringOrNull((Object)recordValue.getParentProcessInstanceKey())) != null) {
            parentTreePath = this.getTreePathCache().get(ConversionUtils.toStringOrNull((Object)recordValue.getParentProcessInstanceKey()));
        }
        if (parentTreePath == null) {
            parentTreePath = this.listViewStore.findProcessInstanceTreePathFor(recordValue.getParentProcessInstanceKey());
        }
        if (parentTreePath != null) {
            String flowNodeInstanceId = ConversionUtils.toStringOrNull((Object)recordValue.getParentElementInstanceKey());
            String callActivityId = this.getCallActivityId(flowNodeInstanceId);
            String treePath = new TreePath(parentTreePath).appendEntries(callActivityId, flowNodeInstanceId, ConversionUtils.toStringOrNull((Object)recordValue.getProcessInstanceKey())).toString();
            this.getTreePathCache().put(ConversionUtils.toStringOrNull((Object)recordValue.getProcessInstanceKey()), treePath);
            return treePath;
        }
        LOGGER.warn("Unable to find parent tree path for parent instance id " + recordValue.getParentProcessInstanceKey());
        String treePath = new TreePath().startTreePath(ConversionUtils.toStringOrNull((Object)recordValue.getProcessInstanceKey())).toString();
        this.getTreePathCache().put(ConversionUtils.toStringOrNull((Object)recordValue.getProcessInstanceKey()), treePath);
        return treePath;
    }

    private String getCallActivityId(String flowNodeInstanceId) {
        String callActivityId = this.getCallActivityIdCache().get(flowNodeInstanceId);
        if (callActivityId == null) {
            callActivityId = this.flowNodeStore.getFlowNodeIdByFlowNodeInstanceId(flowNodeInstanceId);
            this.getCallActivityIdCache().put(flowNodeInstanceId, callActivityId);
        }
        return callActivityId;
    }

    private void updateFlowNodeInstanceFromJob(Record<JobRecordValue> record, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        FlowNodeInstanceForListViewEntity entity = new FlowNodeInstanceForListViewEntity();
        JobRecordValue recordValue = record.getValue();
        String intentStr = record.getIntent().name();
        entity.setKey(record.getValue().getElementInstanceKey());
        entity.setId(ConversionUtils.toStringOrNull((Object)record.getValue().getElementInstanceKey()));
        entity.setPartitionId(record.getPartitionId());
        entity.setPositionJob(Long.valueOf(record.getPosition()));
        entity.setActivityId(recordValue.getElementId());
        entity.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
        entity.setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
        entity.getJoinRelation().setParent(Long.valueOf(recordValue.getProcessInstanceKey()));
        if (FAILED_JOB_EVENTS.contains(intentStr) && recordValue.getRetries() > 0) {
            entity.setJobFailedWithRetriesLeft(true);
        } else {
            entity.setJobFailedWithRetriesLeft(false);
        }
        LOGGER.debug("Update job state for flow node instance: id {} JobFailedWithRetriesLeft {}", (Object)entity.getId(), (Object)entity.isJobFailedWithRetriesLeft());
        HashMap<String, Comparable<Boolean>> updateFields = new HashMap<String, Comparable<Boolean>>();
        updateFields.put("jobFailedWithRetriesLeft", Boolean.valueOf(entity.isJobFailedWithRetriesLeft()));
        updateFields.put("positionJob", entity.getPositionJob());
        if (concurrencyMode) {
            batchRequest.upsertWithScriptAndRouting(this.listViewTemplate.getFullQualifiedName(), entity.getId(), (OperateEntity)entity, this.getFlowNodeInstanceFromJobScript(), updateFields, String.valueOf(recordValue.getProcessInstanceKey()));
        } else {
            batchRequest.upsertWithRouting(this.listViewTemplate.getFullQualifiedName(), entity.getId(), (OperateEntity)entity, updateFields, String.valueOf(recordValue.getProcessInstanceKey()));
        }
    }

    private void updateFlowNodeInstance(Record<ProcessInstanceRecordValue> record, Map<Long, FlowNodeInstanceForListViewEntity> entities) {
        if (entities.get(record.getKey()) == null) {
            entities.put(record.getKey(), new FlowNodeInstanceForListViewEntity());
        }
        FlowNodeInstanceForListViewEntity entity = entities.get(record.getKey());
        ProcessInstanceRecordValue recordValue = record.getValue();
        String intentStr = record.getIntent().name();
        entity.setKey(record.getKey());
        entity.setId(ConversionUtils.toStringOrNull((Object)record.getKey()));
        entity.setPartitionId(record.getPartitionId());
        entity.setPosition(Long.valueOf(record.getPosition()));
        entity.setActivityId(recordValue.getElementId());
        entity.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
        entity.setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
        if (PI_AND_AI_FINISH_STATES.contains(intentStr)) {
            entity.setEndTime(Long.valueOf(record.getTimestamp()));
            if (intentStr.equals(ProcessInstanceIntent.ELEMENT_TERMINATED.name())) {
                entity.setActivityState(FlowNodeState.TERMINATED);
            } else {
                entity.setActivityState(FlowNodeState.COMPLETED);
            }
        } else {
            entity.setActivityState(FlowNodeState.ACTIVE);
            if (PI_AND_AI_START_STATES.contains(intentStr)) {
                entity.setStartTime(Long.valueOf(record.getTimestamp()));
            }
        }
        entity.setActivityType(FlowNodeType.fromZeebeBpmnElementType(recordValue.getBpmnElementType() == null ? null : recordValue.getBpmnElementType().name()));
        if (FlowNodeType.CALL_ACTIVITY.equals((Object)entity.getActivityType())) {
            this.getCallActivityIdCache().put(entity.getId(), entity.getActivityId());
        }
        Long processInstanceKey = recordValue.getProcessInstanceKey();
        entity.getJoinRelation().setParent(processInstanceKey);
    }

    private void processVariableRecord(Record<VariableRecordValue> record, VariableForListViewEntity entity) {
        VariableRecordValue recordValue = record.getValue();
        entity.setId(VariableForListViewEntity.getIdBy((long)recordValue.getScopeKey(), (String)recordValue.getName()));
        entity.setKey(record.getKey());
        entity.setPartitionId(record.getPartitionId());
        entity.setPosition(Long.valueOf(record.getPosition()));
        entity.setScopeKey(Long.valueOf(recordValue.getScopeKey()));
        entity.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
        entity.setVarName(recordValue.getName());
        entity.setVarValue(recordValue.getValue());
        entity.setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
        Long processInstanceKey = recordValue.getProcessInstanceKey();
        entity.getJoinRelation().setParent(processInstanceKey);
    }

    private boolean isProcessEvent(ProcessInstanceRecordValue recordValue) {
        return this.isOfType(recordValue, BpmnElementType.PROCESS);
    }

    private boolean isOfType(ProcessInstanceRecordValue recordValue, BpmnElementType type) {
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        if (bpmnElementType == null) {
            return false;
        }
        return bpmnElementType.equals((Object)type);
    }

    static {
        PI_AND_AI_START_STATES.add(ProcessInstanceIntent.ELEMENT_ACTIVATING.name());
        PI_AND_AI_FINISH_STATES.add(ProcessInstanceIntent.ELEMENT_COMPLETED.name());
        PI_AND_AI_FINISH_STATES.add(ProcessInstanceIntent.ELEMENT_TERMINATED.name());
        FAILED_JOB_EVENTS.add(JobIntent.FAIL.name());
        FAILED_JOB_EVENTS.add(JobIntent.FAILED.name());
    }
}

