/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.v8_5.processors;

import io.camunda.operate.entities.ErrorType;
import io.camunda.operate.entities.EventEntity;
import io.camunda.operate.entities.EventMetadataEntity;
import io.camunda.operate.entities.EventSourceType;
import io.camunda.operate.entities.EventType;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.EventTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.util.DateUtil;
import io.camunda.operate.util.LambdaExceptionUtil;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.v850.record.Record;
import io.camunda.zeebe.protocol.v850.record.RecordValue;
import io.camunda.zeebe.protocol.v850.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.v850.record.intent.JobIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.v850.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.v850.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.v850.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.v850.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.v850.record.value.ProcessMessageSubscriptionRecordValue;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class EventZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventZeebeRecordProcessor.class);
    private static final String ID_PATTERN = "%s_%s";
    private static final Set<String> INCIDENT_EVENTS = new HashSet<String>();
    private static final Set<String> JOB_EVENTS = new HashSet<String>();
    private static final Set<String> PROCESS_INSTANCE_STATES = new HashSet<String>();
    private static final Set<String> PROCESS_MESSAGE_SUBSCRIPTION_STATES = new HashSet<String>();
    @Autowired
    private EventTemplate eventTemplate;

    public void processIncidentRecords(Map<Long, List<Record<IncidentRecordValue>>> records, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        for (List list : records.values()) {
            this.processLastRecord(list, INCIDENT_EVENTS, LambdaExceptionUtil.rethrowConsumer(record -> {
                IncidentRecordValue recordValue = (IncidentRecordValue)record.getValue();
                this.processIncident((Record)record, recordValue, batchRequest, concurrencyMode);
            }));
        }
    }

    public void processJobRecords(Map<Long, List<Record<JobRecordValue>>> records, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        for (List list : records.values()) {
            this.processLastRecord(list, JOB_EVENTS, LambdaExceptionUtil.rethrowConsumer(record -> {
                JobRecordValue recordValue = (JobRecordValue)record.getValue();
                this.processJob((Record)record, recordValue, batchRequest, concurrencyMode);
            }));
        }
    }

    public void processProcessMessageSubscription(Map<Long, List<Record<ProcessMessageSubscriptionRecordValue>>> records, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        for (List list : records.values()) {
            this.processLastRecord(list, PROCESS_MESSAGE_SUBSCRIPTION_STATES, LambdaExceptionUtil.rethrowConsumer(record -> {
                ProcessMessageSubscriptionRecordValue recordValue = (ProcessMessageSubscriptionRecordValue)record.getValue();
                this.processMessage((Record)record, recordValue, batchRequest, concurrencyMode);
            }));
        }
    }

    public void processProcessInstanceRecords(Map<Long, List<Record<ProcessInstanceRecordValue>>> records, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        for (List list : records.values()) {
            this.processLastRecord(list, PROCESS_INSTANCE_STATES, LambdaExceptionUtil.rethrowConsumer(record -> {
                ProcessInstanceRecordValue recordValue = (ProcessInstanceRecordValue)record.getValue();
                this.processProcessInstance((Record)record, recordValue, batchRequest, concurrencyMode);
            }));
        }
    }

    private <T extends RecordValue> void processLastRecord(List<Record<T>> incidentRecords, Set<String> events, Consumer<Record<? extends RecordValue>> recordProcessor) {
        if (incidentRecords.size() >= 1) {
            for (int i = incidentRecords.size() - 1; i >= 0; --i) {
                String intentStr = incidentRecords.get(i).getIntent().name();
                if (!events.contains(intentStr)) continue;
                recordProcessor.accept(incidentRecords.get(i));
                break;
            }
        }
    }

    private void processProcessInstance(Record record, ProcessInstanceRecordValue recordValue, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        if (!this.isProcessEvent(recordValue)) {
            EventEntity eventEntity = ((EventEntity)new EventEntity().setId(String.format(ID_PATTERN, recordValue.getProcessInstanceKey(), record.getKey()))).setPosition(Long.valueOf(record.getPosition()));
            this.loadEventGeneralData(record, eventEntity);
            eventEntity.setProcessDefinitionKey(Long.valueOf(recordValue.getProcessDefinitionKey())).setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
            if (recordValue.getElementId() != null) {
                eventEntity.setFlowNodeId(recordValue.getElementId());
            }
            if (record.getKey() != recordValue.getProcessInstanceKey()) {
                eventEntity.setFlowNodeInstanceKey(Long.valueOf(record.getKey()));
            }
            this.persistEvent(eventEntity, "position", record.getPosition(), batchRequest, concurrencyMode);
        }
    }

    private void processMessage(Record record, ProcessMessageSubscriptionRecordValue recordValue, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        EventEntity eventEntity = ((EventEntity)new EventEntity().setId(String.format(ID_PATTERN, recordValue.getProcessInstanceKey(), recordValue.getElementInstanceKey()))).setPositionProcessMessageSubscription(Long.valueOf(record.getPosition()));
        this.loadEventGeneralData(record, eventEntity);
        long processInstanceKey = recordValue.getProcessInstanceKey();
        if (processInstanceKey > 0L) {
            eventEntity.setProcessInstanceKey(Long.valueOf(processInstanceKey));
        }
        eventEntity.setBpmnProcessId(recordValue.getBpmnProcessId()).setFlowNodeId(recordValue.getElementId()).setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId())).setPositionProcessMessageSubscription(Long.valueOf(record.getPosition()));
        long activityInstanceKey = recordValue.getElementInstanceKey();
        if (activityInstanceKey > 0L) {
            eventEntity.setFlowNodeInstanceKey(Long.valueOf(activityInstanceKey));
        }
        EventMetadataEntity eventMetadata = new EventMetadataEntity();
        eventMetadata.setMessageName(recordValue.getMessageName());
        eventMetadata.setCorrelationKey(recordValue.getCorrelationKey());
        eventEntity.setMetadata(eventMetadata);
        this.persistEvent(eventEntity, "positionProcessMessageSubscription", record.getPosition(), batchRequest, concurrencyMode);
    }

    private void processJob(Record record, JobRecordValue recordValue, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        long jobDeadline;
        long processInstanceKey;
        EventEntity eventEntity = ((EventEntity)new EventEntity().setId(String.format(ID_PATTERN, recordValue.getProcessInstanceKey(), recordValue.getElementInstanceKey()))).setPositionJob(Long.valueOf(record.getPosition()));
        this.loadEventGeneralData(record, eventEntity);
        long processDefinitionKey = recordValue.getProcessDefinitionKey();
        if (processDefinitionKey > 0L) {
            eventEntity.setProcessDefinitionKey(Long.valueOf(processDefinitionKey));
        }
        if ((processInstanceKey = recordValue.getProcessInstanceKey()) > 0L) {
            eventEntity.setProcessInstanceKey(Long.valueOf(processInstanceKey));
        }
        eventEntity.setBpmnProcessId(recordValue.getBpmnProcessId()).setFlowNodeId(recordValue.getElementId()).setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
        long activityInstanceKey = recordValue.getElementInstanceKey();
        if (activityInstanceKey > 0L) {
            eventEntity.setFlowNodeInstanceKey(Long.valueOf(activityInstanceKey));
        }
        EventMetadataEntity eventMetadata = new EventMetadataEntity();
        eventMetadata.setJobType(recordValue.getType());
        eventMetadata.setJobRetries(Integer.valueOf(recordValue.getRetries()));
        eventMetadata.setJobWorker(recordValue.getWorker());
        eventMetadata.setJobCustomHeaders(recordValue.getCustomHeaders());
        if (record.getKey() > 0L) {
            eventMetadata.setJobKey(Long.valueOf(record.getKey()));
        }
        if ((jobDeadline = recordValue.getDeadline()) >= 0L) {
            eventMetadata.setJobDeadline(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(jobDeadline)));
        }
        eventEntity.setMetadata(eventMetadata);
        this.persistEvent(eventEntity, "positionJob", record.getPosition(), batchRequest, concurrencyMode);
    }

    private void processIncident(Record record, IncidentRecordValue recordValue, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        EventEntity eventEntity = ((EventEntity)new EventEntity().setId(String.format(ID_PATTERN, recordValue.getProcessInstanceKey(), recordValue.getElementInstanceKey()))).setPositionIncident(Long.valueOf(record.getPosition()));
        this.loadEventGeneralData(record, eventEntity);
        if (recordValue.getProcessInstanceKey() > 0L) {
            eventEntity.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
        }
        eventEntity.setBpmnProcessId(recordValue.getBpmnProcessId()).setFlowNodeId(recordValue.getElementId()).setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
        if (recordValue.getElementInstanceKey() > 0L) {
            eventEntity.setFlowNodeInstanceKey(Long.valueOf(recordValue.getElementInstanceKey()));
        }
        EventMetadataEntity eventMetadata = new EventMetadataEntity();
        eventMetadata.setIncidentErrorMessage(StringUtils.trimWhitespace((String)recordValue.getErrorMessage()));
        eventMetadata.setIncidentErrorType(ErrorType.fromZeebeErrorType(recordValue.getErrorType() == null ? null : recordValue.getErrorType().name()));
        eventEntity.setMetadata(eventMetadata);
        this.persistEvent(eventEntity, "positionIncident", record.getPosition(), batchRequest, concurrencyMode);
    }

    private boolean isProcessEvent(ProcessInstanceRecordValue recordValue) {
        return this.isOfType(recordValue, BpmnElementType.PROCESS);
    }

    private boolean isOfType(ProcessInstanceRecordValue recordValue, BpmnElementType type) {
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        if (bpmnElementType == null) {
            return false;
        }
        return bpmnElementType.equals((Object)type);
    }

    private void loadEventGeneralData(Record record, EventEntity eventEntity) {
        eventEntity.setKey(record.getKey());
        eventEntity.setPartitionId(record.getPartitionId());
        eventEntity.setEventSourceType(EventSourceType.fromZeebeValueType(record.getValueType() == null ? null : record.getValueType().name()));
        eventEntity.setDateTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
        eventEntity.setEventType(EventType.fromZeebeIntent((String)record.getIntent().name()));
    }

    private void persistEvent(EventEntity entity, String positionFieldName, long positionFieldValue, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        LOGGER.debug("Event: id {}, eventSourceType {}, eventType {}, processInstanceKey {}", new Object[]{entity.getId(), entity.getEventSourceType(), entity.getEventType(), entity.getProcessInstanceKey()});
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("key", entity.getKey());
        jsonMap.put("eventSourceType", entity.getEventSourceType());
        jsonMap.put("eventType", entity.getEventType());
        jsonMap.put("dateTime", entity.getDateTime());
        jsonMap.put("processDefinitionKey", entity.getProcessDefinitionKey());
        jsonMap.put("bpmnProcessId", entity.getBpmnProcessId());
        jsonMap.put("flowNodeId", entity.getFlowNodeId());
        jsonMap.put(positionFieldName, positionFieldValue);
        if (entity.getMetadata() != null) {
            HashMap<String, Object> metadataMap = new HashMap<String, Object>();
            if (entity.getMetadata().getIncidentErrorMessage() != null) {
                metadataMap.put("incidentErrorMessage", entity.getMetadata().getIncidentErrorMessage());
                metadataMap.put("incidentErrorType", entity.getMetadata().getIncidentErrorType());
            }
            if (entity.getMetadata().getJobKey() != null) {
                metadataMap.put("jobKey", entity.getMetadata().getJobKey());
            }
            if (entity.getMetadata().getJobType() != null) {
                metadataMap.put("jobType", entity.getMetadata().getJobType());
                metadataMap.put("jobRetries", entity.getMetadata().getJobRetries());
                metadataMap.put("jobWorker", entity.getMetadata().getJobWorker());
                metadataMap.put("jobCustomHeaders", entity.getMetadata().getJobCustomHeaders());
            }
            if (entity.getMetadata().getMessageName() != null) {
                metadataMap.put("messageName", entity.getMetadata().getMessageName());
                metadataMap.put("correlationKey", entity.getMetadata().getCorrelationKey());
            }
            if (metadataMap.size() > 0) {
                jsonMap.put("metadata", metadataMap);
            }
        }
        if (concurrencyMode) {
            batchRequest.upsertWithScript(this.eventTemplate.getFullQualifiedName(), entity.getId(), (OperateEntity)entity, this.getScript(positionFieldName), jsonMap);
        } else {
            batchRequest.upsert(this.eventTemplate.getFullQualifiedName(), entity.getId(), (OperateEntity)entity, jsonMap);
        }
    }

    private String getScript(String fieldName) {
        return String.format("if (ctx._source.%s == null || ctx._source.%s < params.%s) { ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; ctx._source.%s = params.%s; if (params.%s != null) {   ctx._source.%s = params.%s; }}", fieldName, fieldName, fieldName, fieldName, fieldName, "key", "key", "eventSourceType", "eventSourceType", "eventType", "eventType", "dateTime", "dateTime", "processDefinitionKey", "processDefinitionKey", "bpmnProcessId", "bpmnProcessId", "flowNodeId", "flowNodeId", "metadata", "metadata", "metadata");
    }

    static {
        INCIDENT_EVENTS.add(IncidentIntent.CREATED.name());
        INCIDENT_EVENTS.add(IncidentIntent.RESOLVED.name());
        JOB_EVENTS.add(JobIntent.CREATED.name());
        JOB_EVENTS.add(JobIntent.COMPLETED.name());
        JOB_EVENTS.add(JobIntent.TIMED_OUT.name());
        JOB_EVENTS.add(JobIntent.FAILED.name());
        JOB_EVENTS.add(JobIntent.RETRIES_UPDATED.name());
        JOB_EVENTS.add(JobIntent.CANCELED.name());
        JOB_EVENTS.add(JobIntent.MIGRATED.name());
        PROCESS_INSTANCE_STATES.add(EventType.ELEMENT_ACTIVATING.name());
        PROCESS_INSTANCE_STATES.add(ProcessInstanceIntent.ELEMENT_ACTIVATED.name());
        PROCESS_INSTANCE_STATES.add(EventType.ELEMENT_COMPLETING.name());
        PROCESS_INSTANCE_STATES.add(ProcessInstanceIntent.ELEMENT_COMPLETED.name());
        PROCESS_INSTANCE_STATES.add(ProcessInstanceIntent.ELEMENT_TERMINATED.name());
        PROCESS_MESSAGE_SUBSCRIPTION_STATES.add(ProcessMessageSubscriptionIntent.CREATED.name());
    }
}

