/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v850.record.intent;

import io.camunda.zeebe.protocol.v850.record.intent.Intent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceRelatedIntent;

public enum TimerIntent implements ProcessInstanceRelatedIntent
{
    CREATED(0),
    TRIGGER(1),
    TRIGGERED(2),
    CANCEL(3),
    CANCELED(4),
    MIGRATED(5);

    private final short value;
    private final boolean shouldBanInstance;

    private TimerIntent(short value) {
        this(value, true);
    }

    private TimerIntent(short value, boolean shouldBanInstance) {
        this.value = value;
        this.shouldBanInstance = shouldBanInstance;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean isEvent() {
        switch (this.ordinal()) {
            case 0: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CREATED;
            }
            case 1: {
                return TRIGGER;
            }
            case 2: {
                return TRIGGERED;
            }
            case 3: {
                return CANCEL;
            }
            case 4: {
                return CANCELED;
            }
            case 5: {
                return MIGRATED;
            }
        }
        return Intent.UNKNOWN;
    }

    @Override
    public boolean shouldBanInstanceOnError() {
        return this.shouldBanInstance;
    }
}

