/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.v8_5.processors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.UserTaskEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.UserTaskTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.util.Tuple;
import io.camunda.zeebe.protocol.v850.record.Record;
import io.camunda.zeebe.protocol.v850.record.intent.Intent;
import io.camunda.zeebe.protocol.v850.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.v850.record.value.UserTaskRecordValue;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UserTaskZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskZeebeRecordProcessor.class);
    private static final Set<Intent> CREATE_STATES = Set.of(UserTaskIntent.CREATED);
    private static final Set<Intent> UPDATE_STATES = Set.of(UserTaskIntent.ASSIGNED, UserTaskIntent.MIGRATED, UserTaskIntent.UPDATED, UserTaskIntent.COMPLETED, UserTaskIntent.CANCELED);
    private final UserTaskTemplate userTaskTemplate;
    private final ObjectMapper objectMapper;
    private final Map<Intent, Function<UserTaskEntity, Map<String, Object>>> intentToUpdateFields = Map.of(UserTaskIntent.UPDATED, this::getUpdateFields, UserTaskIntent.MIGRATED, this::getMigratedFields, UserTaskIntent.ASSIGNED, this::getAssignedFields, UserTaskIntent.COMPLETED, this::getCompletedFields, UserTaskIntent.CANCELED, this::getCanceledFields);

    public UserTaskZeebeRecordProcessor(UserTaskTemplate userTaskTemplate, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        this.userTaskTemplate = userTaskTemplate;
        this.objectMapper = objectMapper;
    }

    private Map<String, Object> getCanceledFields(UserTaskEntity userTaskEntity) {
        return Map.of("action", userTaskEntity.getAction());
    }

    private Map<String, Object> getCompletedFields(UserTaskEntity userTaskEntity) {
        return Map.of("variables", userTaskEntity.getVariables(), "action", userTaskEntity.getAction());
    }

    private Map<String, Object> getAssignedFields(UserTaskEntity userTaskEntity) {
        return Map.of("assignee", userTaskEntity.getAssignee(), "action", userTaskEntity.getAction());
    }

    private Map<String, Object> getUpdateFields(UserTaskEntity userTaskEntity) {
        Map<String, Tuple> changedAttributesToUserEntitySupplier = Map.of("candidateUserList", new Tuple((Object)"candidateUsers", () -> ((UserTaskEntity)userTaskEntity).getCandidateUsers()), "candidateUsersList", new Tuple((Object)"candidateUsers", () -> ((UserTaskEntity)userTaskEntity).getCandidateUsers()), "candidateGroupList", new Tuple((Object)"candidateGroups", () -> ((UserTaskEntity)userTaskEntity).getCandidateGroups()), "candidateGroupsList", new Tuple((Object)"candidateGroups", () -> ((UserTaskEntity)userTaskEntity).getCandidateGroups()), "dueDate", new Tuple((Object)"dueDate", () -> ((UserTaskEntity)userTaskEntity).getDueDate()), "followUpDate", new Tuple((Object)"followUpDate", () -> ((UserTaskEntity)userTaskEntity).getFollowUpDate()));
        List changedAttributes = userTaskEntity.getChangedAttributes();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("changedAttributes", changedAttributes);
        map.put("action", userTaskEntity.getAction());
        for (String changedAttribute : changedAttributes) {
            Tuple fieldAndValueSupplier = changedAttributesToUserEntitySupplier.get(changedAttribute);
            if (fieldAndValueSupplier != null) {
                map.put((String)fieldAndValueSupplier.getLeft(), ((Supplier)fieldAndValueSupplier.getRight()).get());
                continue;
            }
            LOGGER.warn("Could not find attribute {} from changed attributes {}. This will be ignored.", (Object)changedAttribute, (Object)changedAttributes);
        }
        return map;
    }

    private Map<String, Object> getMigratedFields(UserTaskEntity userTaskEntity) {
        return Map.of("bpmnProcessId", userTaskEntity.getBpmnProcessId(), "processDefinitionVersion", userTaskEntity.getProcessDefinitionVersion(), "processDefinitionKey", userTaskEntity.getProcessDefinitionKey(), "elementId", userTaskEntity.getElementId());
    }

    public void processUserTaskRecord(BatchRequest batchRequest, Record<UserTaskRecordValue> userTaskRecord) throws PersistenceException {
        UserTaskEntity userTaskEntity;
        Intent intent = userTaskRecord.getIntent();
        LOGGER.info("Intent is: {}", (Object)intent);
        UserTaskRecordValue userTaskValue = userTaskRecord.getValue();
        try {
            userTaskEntity = this.createEntity(userTaskRecord);
        }
        catch (JsonProcessingException e) {
            throw new OperateRuntimeException(String.format("Could not create UserTaskEntity from record value %s", userTaskValue), (Throwable)e);
        }
        if (CREATE_STATES.contains(intent)) {
            this.persistUserTask(userTaskEntity, batchRequest);
        } else if (UPDATE_STATES.contains(intent)) {
            this.updateUserTask(userTaskEntity, this.intentToUpdateFields.get(intent).apply(userTaskEntity), batchRequest);
        } else {
            LOGGER.debug("UserTask record with intent {} is ignored", (Object)intent);
        }
    }

    private void updateUserTask(UserTaskEntity userTaskEntity, Map<String, Object> updateFields, BatchRequest batchRequest) throws PersistenceException {
        batchRequest.upsert(this.userTaskTemplate.getFullQualifiedName(), userTaskEntity.getId(), (OperateEntity)userTaskEntity, updateFields);
        LOGGER.debug("Updated UserTaskEntity {} with update fields {} to batch request", (Object)userTaskEntity.getId(), updateFields);
    }

    private void persistUserTask(UserTaskEntity userTaskEntity, BatchRequest batchRequest) throws PersistenceException {
        batchRequest.addWithId(this.userTaskTemplate.getFullQualifiedName(), userTaskEntity.getId(), (OperateEntity)userTaskEntity);
        LOGGER.debug("Added UserTaskEntity {} to batch request", (Object)userTaskEntity);
    }

    private UserTaskEntity createEntity(Record<UserTaskRecordValue> userTaskRecord) throws JsonProcessingException {
        UserTaskRecordValue userTaskRecordValue = userTaskRecord.getValue();
        return ((UserTaskEntity)((UserTaskEntity)((UserTaskEntity)new UserTaskEntity().setId(String.valueOf(userTaskRecordValue.getUserTaskKey()))).setKey(userTaskRecordValue.getUserTaskKey())).setUserTaskKey(Long.valueOf(userTaskRecordValue.getUserTaskKey())).setPartitionId(userTaskRecord.getPartitionId())).setBpmnProcessId(userTaskRecordValue.getBpmnProcessId()).setTenantId(userTaskRecordValue.getTenantId()).setProcessInstanceKey(Long.valueOf(userTaskRecordValue.getProcessInstanceKey())).setAssignee(userTaskRecordValue.getAssignee()).setCandidateGroups(userTaskRecordValue.getCandidateGroupsList()).setCandidateUsers(userTaskRecordValue.getCandidateUsersList()).setDueDate(this.toDateOrNull(userTaskRecordValue.getDueDate())).setFollowUpDate(this.toDateOrNull(userTaskRecordValue.getFollowUpDate())).setElementId(userTaskRecordValue.getElementId()).setElementInstanceKey(Long.valueOf(userTaskRecordValue.getElementInstanceKey())).setProcessDefinitionKey(Long.valueOf(userTaskRecordValue.getProcessDefinitionKey())).setProcessDefinitionVersion(Integer.valueOf(userTaskRecordValue.getProcessDefinitionVersion())).setVariables(this.objectMapper.writeValueAsString(userTaskRecordValue.getVariables())).setFormKey(Long.valueOf(userTaskRecordValue.getFormKey())).setChangedAttributes(userTaskRecordValue.getChangedAttributes()).setAction(userTaskRecordValue.getAction());
    }

    private OffsetDateTime toDateOrNull(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            return OffsetDateTime.parse(dateString);
        }
        catch (Exception e) {
            LOGGER.warn("Could not parse {} as OffsetDateTime. Use null.", (Object)dateString);
            return null;
        }
    }
}

