/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.v8_5.processors;

import io.camunda.operate.entities.ErrorType;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.IncidentState;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.entities.post.PostImporterActionType;
import io.camunda.operate.entities.post.PostImporterQueueEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.schema.templates.PostImporterQueueTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.util.DateUtil;
import io.camunda.operate.util.OperationsManager;
import io.camunda.operate.zeebeimport.IncidentNotifier;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.v850.record.Record;
import io.camunda.zeebe.protocol.v850.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.v850.record.value.IncidentRecordValue;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class IncidentZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncidentZeebeRecordProcessor.class);
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private IncidentTemplate incidentTemplate;
    @Autowired
    private PostImporterQueueTemplate postImporterQueueTemplate;
    @Autowired
    private OperationsManager operationsManager;
    @Autowired
    private IncidentNotifier incidentNotifier;

    public void processIncidentRecord(List<Record> records, BatchRequest batchRequest, boolean concurrencyMode) throws PersistenceException {
        ArrayList newIncidents = new ArrayList();
        for (Record record : records) {
            this.processIncidentRecord(record, batchRequest, newIncidents::add, concurrencyMode);
        }
        if (this.operateProperties.getAlert().getWebhook() != null) {
            this.incidentNotifier.notifyOnIncidents(newIncidents);
        }
    }

    public void processIncidentRecord(Record record, BatchRequest batchRequest, Consumer<IncidentEntity> newIncidentHandler, boolean concurrencyMode) throws PersistenceException {
        IncidentRecordValue recordValue = (IncidentRecordValue)record.getValue();
        this.persistIncident(record, recordValue, batchRequest, newIncidentHandler, concurrencyMode);
        this.persistPostImportQueueEntry(record, recordValue, batchRequest);
    }

    private void persistPostImportQueueEntry(Record record, IncidentRecordValue recordValue, BatchRequest batchRequest) throws PersistenceException {
        String intent = record.getIntent().name();
        if (intent.equals(IncidentIntent.MIGRATED.toString())) {
            intent = IncidentIntent.CREATED.toString();
        }
        PostImporterQueueEntity postImporterQueueEntity = ((PostImporterQueueEntity)new PostImporterQueueEntity().setId(String.format("%d-%s", record.getKey(), intent))).setActionType(PostImporterActionType.INCIDENT).setIntent(intent).setKey(Long.valueOf(record.getKey())).setPosition(Long.valueOf(record.getPosition())).setCreationTime(OffsetDateTime.now()).setPartitionId(Integer.valueOf(record.getPartitionId())).setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
        batchRequest.add(this.postImporterQueueTemplate.getFullQualifiedName(), (OperateEntity)postImporterQueueEntity);
    }

    private void persistIncident(Record record, IncidentRecordValue recordValue, BatchRequest batchRequest, Consumer<IncidentEntity> newIncidentHandler, boolean concurrencyMode) throws PersistenceException {
        String intentStr = record.getIntent().name();
        Long incidentKey = record.getKey();
        if (intentStr.equals(IncidentIntent.RESOLVED.toString())) {
            this.operationsManager.completeOperation(null, Long.valueOf(recordValue.getProcessInstanceKey()), incidentKey, OperationType.RESOLVE_INCIDENT, batchRequest);
        } else {
            IncidentEntity incident = ((IncidentEntity)((IncidentEntity)((IncidentEntity)new IncidentEntity().setId(ConversionUtils.toStringOrNull((Object)incidentKey))).setKey(incidentKey.longValue())).setPartitionId(record.getPartitionId())).setPosition(Long.valueOf(record.getPosition()));
            if (recordValue.getJobKey() > 0L) {
                incident.setJobKey(Long.valueOf(recordValue.getJobKey()));
            }
            if (recordValue.getProcessInstanceKey() > 0L) {
                incident.setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey()));
            }
            if (recordValue.getProcessDefinitionKey() > 0L) {
                incident.setProcessDefinitionKey(Long.valueOf(recordValue.getProcessDefinitionKey()));
            }
            incident.setBpmnProcessId(recordValue.getBpmnProcessId());
            String errorMessage = StringUtils.trimWhitespace((String)recordValue.getErrorMessage());
            incident.setErrorMessage(errorMessage).setErrorType(ErrorType.fromZeebeErrorType(recordValue.getErrorType() == null ? null : recordValue.getErrorType().name())).setFlowNodeId(recordValue.getElementId());
            if (recordValue.getElementInstanceKey() > 0L) {
                incident.setFlowNodeInstanceKey(Long.valueOf(recordValue.getElementInstanceKey()));
            }
            incident.setState(IncidentState.PENDING).setCreationTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp()))).setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
            LOGGER.debug("Index incident: id {}", (Object)incident.getId());
            Map<String, Object> updateFields = IncidentZeebeRecordProcessor.getUpdateFieldsMapByIntent(intentStr, incident);
            updateFields.put("position", incident.getPosition());
            if (concurrencyMode) {
                batchRequest.upsertWithScript(this.incidentTemplate.getFullQualifiedName(), String.valueOf(incident.getKey()), (OperateEntity)incident, this.getScript(), updateFields);
            } else {
                batchRequest.upsert(this.incidentTemplate.getFullQualifiedName(), String.valueOf(incident.getKey()), (OperateEntity)incident, updateFields);
            }
            newIncidentHandler.accept(incident);
        }
    }

    private static Map<String, Object> getUpdateFieldsMapByIntent(String intent, IncidentEntity incidentEntity) {
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        if (intent.equals(IncidentIntent.MIGRATED.name())) {
            updateFields.put("bpmnProcessId", incidentEntity.getBpmnProcessId());
            updateFields.put("processDefinitionKey", incidentEntity.getProcessDefinitionKey());
            updateFields.put("flowNodeId", incidentEntity.getFlowNodeId());
        }
        return updateFields;
    }

    private String getScript() {
        return String.format("if (ctx._source.%s == null || ctx._source.%s < params.%s) { ctx._source.%s = params.%s; if (params.%s != null) {   ctx._source.%s = params.%s;    ctx._source.%s = params.%s;    ctx._source.%s = params.%s; }}", "position", "position", "position", "position", "position", "processDefinitionKey", "processDefinitionKey", "bpmnProcessId", "bpmnProcessId", "flowNodeId", "flowNodeId");
    }
}

