/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.util;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.util.ConversionUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class CollectionUtil {
    public static <K, V> V getOrDefaultForNullValue(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        return value == null ? defaultValue : value;
    }

    public static <K, T> T getOrDefaultFromMap(Map<K, T> map, K key, T defaultValue) {
        return key == null ? defaultValue : map.getOrDefault(key, defaultValue);
    }

    public static <T> T firstOrDefault(List<T> list, T defaultValue) {
        return list.isEmpty() ? defaultValue : list.get(0);
    }

    @SafeVarargs
    public static <T> List<T> throwAwayNullElements(T ... array) {
        ArrayList<T> listOfNotNulls = new ArrayList<T>();
        for (T o : array) {
            if (o == null) continue;
            listOfNotNulls.add(o);
        }
        return listOfNotNulls;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static <T> List<T> emptyListWhenNull(List<T> aList) {
        return aList == null ? Collections.emptyList() : aList;
    }

    public static <T> List<T> withoutNulls(Collection<T> aCollection) {
        if (aCollection != null) {
            return CollectionUtil.filter(aCollection, Objects::nonNull);
        }
        return Collections.emptyList();
    }

    public static <T, S> Map<T, List<S>> addToMap(Map<T, List<S>> map, T key, S value) {
        map.computeIfAbsent(key, k -> new ArrayList()).add(value);
        return map;
    }

    public static Map<String, Object> asMap(Object ... keyValuePairs) {
        if (keyValuePairs == null || keyValuePairs.length % 2 != 0) {
            throw new OperateRuntimeException("keyValuePairs should not be null and has a even length.");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < keyValuePairs.length - 1; i += 2) {
            result.put(keyValuePairs[i].toString(), keyValuePairs[i + 1]);
        }
        return result;
    }

    public static <S, T> List<T> map(Collection<S> sourceList, Function<? super S, T> mapper) {
        return CollectionUtil.map(sourceList.stream(), mapper);
    }

    public static <S, T> List<T> map(S[] sourceArray, Function<S, T> mapper) {
        return CollectionUtil.map((Stream)Arrays.stream(sourceArray).parallel(), mapper);
    }

    public static <S, T> List<T> map(Stream<S> sequenceStream, Function<? super S, T> mapper) {
        return sequenceStream.map(mapper).collect(Collectors.toList());
    }

    public static <T> List<T> filter(Collection<T> collection, Predicate<T> predicate) {
        return CollectionUtil.filter(collection.stream(), predicate);
    }

    public static <T> List<T> filter(Stream<T> filterStream, Predicate<T> predicate) {
        return filterStream.filter(predicate).collect(Collectors.toList());
    }

    public static List<String> toSafeListOfStrings(Collection<?> aCollection) {
        return CollectionUtil.map(CollectionUtil.withoutNulls(aCollection), Object::toString);
    }

    public static String[] toSafeArrayOfStrings(Collection<?> aCollection) {
        return CollectionUtil.toSafeListOfStrings(aCollection).toArray(new String[0]);
    }

    public static List<String> toSafeListOfStrings(Object ... objects) {
        return CollectionUtil.toSafeListOfStrings(Arrays.asList(objects));
    }

    public static List<Long> toSafeListOfLongs(Collection<String> aCollection) {
        return CollectionUtil.map(CollectionUtil.withoutNulls(aCollection), ConversionUtils.STRING_TO_LONG);
    }

    public static <T> void addNotNull(Collection<T> collection, T object) {
        if (collection != null && object != null) {
            collection.add(object);
        }
    }

    public static List<Integer> fromTo(int from, int to) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = from; i <= to; ++i) {
            result.add(i);
        }
        return result;
    }

    public static boolean isNotEmpty(Collection<?> aCollection) {
        return aCollection != null && !aCollection.isEmpty();
    }

    public static boolean isEmpty(Collection<?> aCollection) {
        return aCollection == null || aCollection.isEmpty();
    }

    public static boolean isEmpty(Object ... objects) {
        return objects == null || objects.length == 0;
    }

    public static <E> List<E> splitAndGetSublist(List<E> list, int subsetCount, int subsetId) {
        if (subsetId >= subsetCount) {
            return new ArrayList();
        }
        Integer size = list.size();
        int bucketSize = (int)Math.round((double)size.intValue() / (double)subsetCount);
        int start = bucketSize * subsetId;
        int end = subsetId == subsetCount - 1 ? size : start + bucketSize;
        return new ArrayList<E>(list.subList(start, end));
    }

    public static <T> T chooseOne(List<T> items) {
        return items.get(new Random().nextInt(items.size()));
    }

    public static <T> boolean allElementsAreOfType(Class clazz, T ... array) {
        for (T element : array) {
            if (clazz.isInstance(element)) continue;
            return false;
        }
        return true;
    }

    public static long countNonNullObjects(Object ... objects) {
        return Arrays.stream(objects).filter(Objects::nonNull).count();
    }

    public static <T> List<T> reversedView(final List<T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return list.get(list.size() - 1 - index);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }
}

