/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.camunda.operate.logging.ByteBufferDestinationOutputStream;
import io.camunda.operate.logging.stackdriver.StackdriverLogEntry;
import io.camunda.operate.logging.stackdriver.StackdriverLogEntryBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;

@Plugin(name="StackdriverLayout", category="Core", elementType="layout")
public final class StackdriverLayout
extends AbstractLayout<byte[]>
implements LocationAware {
    private static final ObjectWriter WRITER = new ObjectMapper().writerFor(StackdriverLogEntry.class);
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    private static final String DEFAULT_SERVICE_VERSION = "development";
    private static final String DEFAULT_SERVICE_NAME = "zeebe";
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] LINE_SEPARATOR = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
    private final String serviceName;
    private final String serviceVersion;

    public StackdriverLayout() {
        this((Configuration)new DefaultConfiguration(), DEFAULT_SERVICE_NAME, DEFAULT_SERVICE_VERSION);
    }

    public StackdriverLayout(Configuration configuration, String serviceName, String serviceVersion) {
        super(configuration, null, null);
        this.serviceName = serviceName == null || serviceName.isBlank() ? DEFAULT_SERVICE_NAME : serviceName;
        this.serviceVersion = serviceVersion == null || serviceVersion.isBlank() ? DEFAULT_SERVICE_VERSION : serviceVersion;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public byte[] toByteArray(LogEvent event) {
        return this.toSerializable(event);
    }

    public byte[] toSerializable(LogEvent event) {
        byte[] byArray;
        StackdriverLogEntry entry = this.buildLogEntry(event);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            WRITER.writeValue((OutputStream)output, (Object)entry);
            output.write(LINE_SEPARATOR);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
                return EMPTY;
            }
        }
        output.close();
        return byArray;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        StackdriverLogEntry entry = this.buildLogEntry(event);
        try (ByteBufferDestinationOutputStream output = new ByteBufferDestinationOutputStream(destination);){
            WRITER.writeValue((OutputStream)output, (Object)entry);
            output.write(LINE_SEPARATOR);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    public boolean requiresLocation() {
        return false;
    }

    private StackdriverLogEntry buildLogEntry(LogEvent event) {
        String loggerName;
        String threadName;
        ThrowableProxy thrownProxy;
        StackdriverLogEntryBuilder builder = StackdriverLogEntry.builder().withLevel(event.getLevel()).withMessage(event.getMessage().getFormattedMessage()).withTime(event.getInstant()).withDiagnosticContext(event.getContextData()).withThreadId(event.getThreadId()).withThreadPriority(event.getThreadPriority()).withServiceName(this.serviceName).withServiceVersion(this.serviceVersion);
        StackTraceElement source = event.getSource();
        if (source != null) {
            builder.withSource(source);
        }
        if ((thrownProxy = event.getThrownProxy()) != null) {
            builder.withException(thrownProxy);
        }
        if ((threadName = event.getThreadName()) != null) {
            builder.withThreadName(threadName);
        }
        if ((loggerName = event.getLoggerName()) != null) {
            builder.withLogger(loggerName);
        }
        return builder.build();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<StackdriverLayout> {
        @PluginBuilderAttribute(value="serviceName")
        private String serviceName;
        @PluginBuilderAttribute(value="serviceVersion")
        private String serviceVersion;

        public StackdriverLayout build() {
            return new StackdriverLayout(this.getConfiguration(), this.getServiceName(), this.getServiceVersion());
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public B setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getServiceVersion() {
            return this.serviceVersion;
        }

        public B setServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

