/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.opensearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.EndpointWithResponseMapperAttr;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;

public class ExtendedOpenSearchClient
extends OpenSearchClient {
    private static final Pattern SEARCH_AFTER_PATTERN = Pattern.compile("(\"search_after\":\\[[^\\]]*\\])");
    private static final String DOCUMENT_ATTR = "org.opensearch.client:Deserializer:_global.search.TDocument";

    public ExtendedOpenSearchClient(OpenSearchTransport transport) {
        super(transport);
    }

    private static <R> SimpleEndpoint<Map<String, Object>, R> arbitraryEndpoint(String method, String path, JsonpDeserializer<R> responseParser) {
        boolean hasBody = !List.of("GET", "DELETE").contains(method.toUpperCase());
        return new SimpleEndpoint(request -> method, request -> path, request -> Map.of(), request -> Map.of(), hasBody, responseParser);
    }

    private ObjectMapper objectMapper() {
        return ((JacksonJsonpMapper)((OpenSearchTransport)this.transport).jsonpMapper()).objectMapper();
    }

    private Map<String, Object> jsonToMap(String json) throws JsonProcessingException {
        return (Map)this.objectMapper().readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(this){});
    }

    private String json(SearchRequest request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator generator = ((OpenSearchTransport)this.transport).jsonpMapper().jsonProvider().createGenerator((OutputStream)baos);
        request.serialize(generator, ((OpenSearchTransport)this.transport).jsonpMapper());
        generator.close();
        return baos.toString();
    }

    private String fixSearchAfter(String json) {
        Matcher m = SEARCH_AFTER_PATTERN.matcher(json);
        if (m.find()) {
            String searchAfter = m.group(1);
            String fixedSearchAfter = searchAfter.replaceAll(String.format("\"%s\"", Long.MIN_VALUE), String.valueOf(Long.MIN_VALUE));
            return json.replace(searchAfter, fixedSearchAfter);
        }
        return json;
    }

    public <TDocument> SearchResponse<TDocument> fixedSearch(SearchRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        String path = String.format("/%s/_search", String.join((CharSequence)",", request.index()));
        EndpointWithResponseMapperAttr endpoint = ExtendedOpenSearchClient.arbitraryEndpoint("POST", path, SearchResponse._DESERIALIZER);
        endpoint = new EndpointWithResponseMapperAttr(endpoint, DOCUMENT_ATTR, (Object)this.getDeserializer(tDocumentClass));
        String requestJson = this.json(request);
        requestJson = this.fixSearchAfter(requestJson);
        return (SearchResponse)this.arbitraryRequest(requestJson, (JsonEndpoint)endpoint);
    }

    public Map<String, Object> searchAsMap(SearchRequest request) throws IOException, OpenSearchException {
        SimpleEndpoint endpoint = SearchRequest._ENDPOINT.withResponseDeserializer(this.getDeserializer(HashMap.class));
        return (Map)((OpenSearchTransport)this.transport).performRequest((Object)request, (Endpoint)endpoint, ((OpenSearchTransport)this.transport).options());
    }

    public Map<String, Object> arbitraryRequest(String method, String path, String json) throws IOException, OpenSearchException {
        SimpleEndpoint endpoint = ExtendedOpenSearchClient.arbitraryEndpoint(method, path, this.getDeserializer(HashMap.class));
        return (Map)this.arbitraryRequest(json, (JsonEndpoint)endpoint);
    }

    private <R> R arbitraryRequest(String json, JsonEndpoint<Map<String, Object>, R, ErrorResponse> endpoint) throws IOException, OpenSearchException {
        return (R)((OpenSearchTransport)this.transport).performRequest(this.jsonToMap(json), endpoint, ((OpenSearchTransport)this.transport).options());
    }
}

