/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.conditions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.operate.conditions.DatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="databaseInfo")
public class DatabaseInfo
implements ApplicationContextAware {
    static final DatabaseType DEFAULT_DATABASE = DatabaseType.Elasticsearch;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseInfo.class);
    private static ApplicationContext applicationContext;
    private static DatabaseType current;

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"}, justification="We want to avoid the fight for a lock on this method.")
    public static DatabaseType getCurrent() {
        if (current == null) {
            if (applicationContext == null) {
                LOGGER.warn("getCurrent() called on DatabaseInfo before application context has been set");
                return DEFAULT_DATABASE;
            }
            String code = applicationContext.getEnvironment().getProperty("camunda.operate.database");
            current = DatabaseType.byCode(code).orElse(DEFAULT_DATABASE);
        }
        return current;
    }

    public static boolean isCurrent(DatabaseType databaseType) {
        return databaseType == DatabaseInfo.getCurrent();
    }

    public static boolean isElasticsearch() {
        return DatabaseInfo.isCurrent(DatabaseType.Elasticsearch);
    }

    public static boolean isOpensearch() {
        return DatabaseInfo.isCurrent(DatabaseType.Opensearch);
    }

    public boolean isOpensearchDb() {
        return DatabaseInfo.isOpensearch();
    }

    public boolean isElasticsearchDb() {
        return DatabaseInfo.isElasticsearch();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        DatabaseInfo.applicationContext = applicationContext;
    }
}

