/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.document.store;

import io.camunda.document.api.DocumentStore;
import io.camunda.document.api.DocumentStoreRecord;
import io.camunda.document.api.DocumentStoreRegistry;
import io.camunda.document.store.GcpDocumentStore;
import io.camunda.document.store.InMemoryDocumentStore;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDocumentStoreRegistry
implements DocumentStoreRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleDocumentStoreRegistry.class);
    private static final String GCP_STORE_BUCKET_NAME_VARIABLE = "CAMUNDA_DOCUMENT_STORE_GCP_BUCKET";
    private static final String STORE_ID_GCP = "gcp";
    private static final String STORE_ID_IN_MEMORY = "in-memory";
    private final Map<String, DocumentStore> stores = new HashMap<String, DocumentStore>();

    public SimpleDocumentStoreRegistry() {
        String gcpBucketName = System.getenv(GCP_STORE_BUCKET_NAME_VARIABLE);
        if (gcpBucketName != null) {
            this.stores.put(STORE_ID_GCP, new GcpDocumentStore(gcpBucketName));
        } else {
            LOG.warn("No GCP bucket name provided, using in-memory document instance");
        }
        this.stores.put(STORE_ID_IN_MEMORY, new InMemoryDocumentStore());
    }

    public DocumentStoreRecord getDocumentStore(String id) {
        DocumentStore store = this.stores.get(id);
        if (store == null) {
            throw new IllegalArgumentException("No such document store: " + id);
        }
        return new DocumentStoreRecord(id, store);
    }

    public DocumentStoreRecord getDefaultDocumentStore() {
        if (this.stores.containsKey(STORE_ID_GCP)) {
            return new DocumentStoreRecord(STORE_ID_GCP, this.stores.get(STORE_ID_GCP));
        }
        return new DocumentStoreRecord(STORE_ID_IN_MEMORY, this.stores.get(STORE_ID_IN_MEMORY));
    }
}

