/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.outbound.jobhandling;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.api.validation.ValidationProvider;
import io.camunda.connector.runtime.core.config.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.core.error.BpmnError;
import io.camunda.connector.runtime.core.outbound.ConnectorJobHandler;
import io.camunda.connector.runtime.core.outbound.ConnectorResult;
import io.camunda.connector.runtime.core.secret.SecretProviderAggregator;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringConnectorJobHandler
extends ConnectorJobHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConnectorJobHandler.class);
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final MetricsRecorder metricsRecorder;
    private final OutboundConnectorConfiguration connectorConfiguration;

    public SpringConnectorJobHandler(MetricsRecorder metricsRecorder, CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, SecretProviderAggregator secretProviderAggregator, ValidationProvider validationProvider, ObjectMapper objectMapper, OutboundConnectorFunction connectorFunction, OutboundConnectorConfiguration connectorConfiguration) {
        super(connectorFunction, (SecretProvider)secretProviderAggregator, validationProvider, objectMapper);
        this.metricsRecorder = metricsRecorder;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.connectorConfiguration = connectorConfiguration;
    }

    public void handle(JobClient client, ActivatedJob job) {
        this.metricsRecorder.executeWithTimer("camunda.connector.outbound.execution-time", job.getType(), () -> {
            this.metricsRecorder.increase("camunda.connector.outbound.invocations", "activated", this.connectorConfiguration.type());
            try {
                super.handle(client, job);
            }
            catch (Exception e) {
                this.metricsRecorder.increase("camunda.connector.outbound.invocations", "failed", this.connectorConfiguration.type());
                LOGGER.warn("Failed to handle job: " + String.valueOf(job));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failJob(JobClient client, ActivatedJob job, ConnectorResult.ErrorResult result) {
        try {
            this.metricsRecorder.increase("camunda.connector.outbound.invocations", "failed", this.connectorConfiguration.type());
        }
        finally {
            FinalCommandStep commandStep = SpringConnectorJobHandler.prepareFailJobCommand((JobClient)client, (ActivatedJob)job, (ConnectorResult.ErrorResult)result);
            new CommandWrapper(commandStep, job, this.commandExceptionHandlingStrategy).executeAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void throwBpmnError(JobClient client, ActivatedJob job, BpmnError value) {
        try {
            this.metricsRecorder.increase("camunda.connector.outbound.invocations", "bpmn-error", this.connectorConfiguration.type());
        }
        finally {
            new CommandWrapper(SpringConnectorJobHandler.prepareThrowBpmnErrorCommand((JobClient)client, (ActivatedJob)job, (BpmnError)value), job, this.commandExceptionHandlingStrategy).executeAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeJob(JobClient client, ActivatedJob job, ConnectorResult.SuccessResult result) {
        try {
            this.metricsRecorder.increase("camunda.connector.outbound.invocations", "completed", this.connectorConfiguration.type());
        }
        finally {
            FinalCommandStep commandStep = SpringConnectorJobHandler.prepareCompleteJobCommand((JobClient)client, (ActivatedJob)job, (ConnectorResult.SuccessResult)result);
            new CommandWrapper(commandStep, job, this.commandExceptionHandlingStrategy).executeAsync();
        }
    }
}

