/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.state;

import io.camunda.connector.runtime.core.inbound.InboundConnectorElement;
import io.camunda.connector.runtime.inbound.executable.InboundExecutableEvent;
import io.camunda.connector.runtime.inbound.executable.InboundExecutableRegistry;
import io.camunda.connector.runtime.inbound.state.ProcessDefinitionInspector;
import io.camunda.connector.runtime.inbound.state.ProcessImportResult;
import io.camunda.connector.runtime.inbound.state.ProcessStateStore;
import io.camunda.operate.exception.OperateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessStateStoreImpl
implements ProcessStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessStateStoreImpl.class);
    private final Map<String, ProcessState> processStates = new HashMap<String, ProcessState>();
    private final ProcessDefinitionInspector processDefinitionInspector;
    private final InboundExecutableRegistry executableRegistry;

    public ProcessStateStoreImpl(ProcessDefinitionInspector processDefinitionInspector, InboundExecutableRegistry executableRegistry) {
        this.processDefinitionInspector = processDefinitionInspector;
        this.executableRegistry = executableRegistry;
    }

    @Override
    public void update(ProcessImportResult processDefinitions) {
        Set<Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion>> entries = processDefinitions.processDefinitionVersions().entrySet();
        List<Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion>> newlyDeployed = entries.stream().filter(entry -> !this.processStates.containsKey(((ProcessImportResult.ProcessDefinitionIdentifier)entry.getKey()).bpmnProcessId())).toList();
        List<Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion>> replacedWithDifferentVersion = entries.stream().filter(entry -> {
            ProcessState state = this.processStates.get(((ProcessImportResult.ProcessDefinitionIdentifier)entry.getKey()).bpmnProcessId());
            return state != null && state.version() != ((ProcessImportResult.ProcessDefinitionVersion)entry.getValue()).version();
        }).toList();
        List<String> deletedProcessIds = this.processStates.keySet().stream().filter(processState -> processDefinitions.processDefinitionVersions().keySet().stream().noneMatch(key -> key.bpmnProcessId().equals(processState))).toList();
        this.logResult(newlyDeployed, replacedWithDifferentVersion, deletedProcessIds);
        newlyDeployed.forEach(this::newlyDeployed);
        replacedWithDifferentVersion.forEach(this::replacedWithDifferentVersion);
        deletedProcessIds.forEach(this::deleted);
    }

    private void newlyDeployed(Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion> entry) {
        try {
            this.processStates.compute(entry.getKey().bpmnProcessId(), (key, state) -> {
                List<InboundConnectorElement> connectorElements = this.getConnectors(entry);
                this.activate(((ProcessImportResult.ProcessDefinitionIdentifier)entry.getKey()).tenantId(), ((ProcessImportResult.ProcessDefinitionVersion)entry.getValue()).processDefinitionKey(), connectorElements);
                return new ProcessState(((ProcessImportResult.ProcessDefinitionVersion)entry.getValue()).version(), ((ProcessImportResult.ProcessDefinitionVersion)entry.getValue()).processDefinitionKey(), ((ProcessImportResult.ProcessDefinitionIdentifier)entry.getKey()).tenantId(), connectorElements);
            });
        }
        catch (Throwable e) {
            LOG.error("Failed to register process {}", (Object)entry.getKey().bpmnProcessId(), (Object)e);
        }
    }

    private void replacedWithDifferentVersion(Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion> entry) {
        try {
            this.processStates.computeIfPresent(entry.getKey().bpmnProcessId(), (key, state) -> {
                List<InboundConnectorElement> newConnectorElements = this.getConnectors(entry);
                this.deactivate(((ProcessImportResult.ProcessDefinitionIdentifier)entry.getKey()).tenantId(), state.processDefinitionKey);
                this.activate(((ProcessImportResult.ProcessDefinitionIdentifier)entry.getKey()).tenantId(), ((ProcessImportResult.ProcessDefinitionVersion)entry.getValue()).processDefinitionKey(), newConnectorElements);
                return new ProcessState(((ProcessImportResult.ProcessDefinitionVersion)entry.getValue()).version(), ((ProcessImportResult.ProcessDefinitionVersion)entry.getValue()).processDefinitionKey(), ((ProcessImportResult.ProcessDefinitionIdentifier)entry.getKey()).tenantId(), newConnectorElements);
            });
        }
        catch (Throwable e) {
            LOG.error("Failed to update process {}", (Object)entry.getKey().bpmnProcessId(), (Object)e);
        }
    }

    private void deleted(String processId) {
        try {
            this.processStates.computeIfPresent(processId, (key1, state) -> {
                String tenantId = state.tenantId;
                this.deactivate(tenantId, state.processDefinitionKey);
                return null;
            });
        }
        catch (Throwable e) {
            LOG.error("Failed to deregister process {}", (Object)processId, (Object)e);
        }
    }

    private List<InboundConnectorElement> getConnectors(Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion> entry) {
        try {
            List<InboundConnectorElement> elements = this.processDefinitionInspector.findInboundConnectors(entry.getKey(), entry.getValue());
            if (elements.isEmpty()) {
                LOG.debug("No inbound connectors found for process {}", (Object)entry.getKey().bpmnProcessId());
            }
            return elements;
        }
        catch (OperateException e) {
            throw new RuntimeException(e);
        }
    }

    private void activate(String tenantId, long processDefinitionKey, List<InboundConnectorElement> elements) {
        InboundExecutableEvent.Activated event = new InboundExecutableEvent.Activated(tenantId, processDefinitionKey, elements);
        this.executableRegistry.publishEvent(event);
    }

    private void deactivate(String tenantId, long processDefinitionKey) {
        InboundExecutableEvent.Deactivated event = new InboundExecutableEvent.Deactivated(tenantId, processDefinitionKey);
        this.executableRegistry.publishEvent(event);
    }

    private void logResult(List<Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion>> brandNew, List<Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion>> upgraded, List<String> deleted) {
        if (brandNew.isEmpty() && upgraded.isEmpty() && deleted.isEmpty()) {
            LOG.debug("No changes in process elements");
            return;
        }
        LOG.info("Detected changes in process elements");
        LOG.info(". {} newly deployed", (Object)brandNew.size());
        for (Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion> pd : brandNew) {
            LOG.info(". Process: {}, version: {} for tenant: {}", new Object[]{pd.getKey().bpmnProcessId(), pd.getValue().version(), pd.getKey().tenantId()});
        }
        LOG.info(". {} replaced with new version", (Object)upgraded.size());
        for (Map.Entry<ProcessImportResult.ProcessDefinitionIdentifier, ProcessImportResult.ProcessDefinitionVersion> pd : upgraded) {
            int oldVersion = this.processStates.get(pd.getKey().bpmnProcessId()).version();
            LOG.info(". Process: {}, version {} - replaced with version {} for tenant: {}", new Object[]{pd.getKey().bpmnProcessId(), oldVersion, pd.getValue().version(), pd.getKey().tenantId()});
        }
        LOG.info(". {} deleted", (Object)deleted.size());
        for (String key : deleted) {
            LOG.info(". . Process {}", (Object)key);
        }
    }

    private record ProcessState(int version, long processDefinitionKey, String tenantId, List<InboundConnectorElement> connectorElements) {
    }
}

