/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.state;

import io.camunda.connector.api.inbound.ProcessElement;
import io.camunda.connector.runtime.core.error.InvalidInboundConnectorDefinitionException;
import io.camunda.connector.runtime.core.inbound.InboundConnectorElement;
import io.camunda.connector.runtime.core.inbound.correlation.MessageCorrelationPoint;
import io.camunda.connector.runtime.core.inbound.correlation.MessageStartEventCorrelationPoint;
import io.camunda.connector.runtime.core.inbound.correlation.ProcessCorrelationPoint;
import io.camunda.connector.runtime.core.inbound.correlation.StartEventCorrelationPoint;
import io.camunda.connector.runtime.inbound.state.ProcessImportResult;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.exception.OperateException;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.ReceiveTask;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeProperties;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeProperty;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionInspector {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionInspector.class);
    private static final List<Class<? extends BaseElement>> INBOUND_ELIGIBLE_TYPES = new ArrayList<Class<? extends BaseElement>>();
    private final CamundaOperateClient operate;

    public ProcessDefinitionInspector(CamundaOperateClient operate) {
        this.operate = operate;
    }

    public List<InboundConnectorElement> findInboundConnectors(ProcessImportResult.ProcessDefinitionIdentifier identifier, ProcessImportResult.ProcessDefinitionVersion version) throws OperateException {
        LOG.debug("Checking {} (version {}) for connectors.", (Object)identifier, (Object)version.version());
        BpmnModelInstance modelInstance = this.operate.getProcessDefinitionModel(Long.valueOf(version.processDefinitionKey()));
        Optional<Process> processes = modelInstance.getDefinitions().getChildElementsByType(Process.class).stream().filter(p -> p.getId().equals(identifier.bpmnProcessId())).findFirst();
        return processes.stream().flatMap(process -> this.inspectBpmnProcess((Process)process, identifier, version).stream()).toList();
    }

    private List<InboundConnectorElement> inspectBpmnProcess(Process process, ProcessImportResult.ProcessDefinitionIdentifier identifier, ProcessImportResult.ProcessDefinitionVersion version) {
        Collection<BaseElement> inboundEligibleElements = this.retrieveEligibleElementsFromProcess(process);
        ArrayList<InboundConnectorElement> discoveredInboundConnectors = new ArrayList<InboundConnectorElement>();
        for (BaseElement element : inboundEligibleElements) {
            Optional<ProcessCorrelationPoint> optionalTarget = this.getCorrelationPointForElement(element, process, identifier, version);
            if (optionalTarget.isEmpty()) continue;
            ProcessCorrelationPoint target = optionalTarget.get();
            Map<String, String> rawProperties = this.getRawProperties(element);
            if (rawProperties == null || !rawProperties.containsKey("inbound.type")) {
                LOG.debug("Not a connector: " + element.getId());
                continue;
            }
            ProcessElement processElement = new ProcessElement(process.getId(), version.version(), version.processDefinitionKey(), element.getId(), identifier.tenantId());
            InboundConnectorElement def = new InboundConnectorElement(rawProperties, target, processElement);
            discoveredInboundConnectors.add(def);
        }
        return discoveredInboundConnectors;
    }

    private Collection<BaseElement> retrieveEligibleElementsFromProcess(Process process) {
        HashSet<FlowElement> buffer = new HashSet<FlowElement>();
        Collection<FlowElement> allElements = this.collectFlowElements(process.getFlowElements(), buffer);
        HashSet<BaseElement> inboundEligibleElements = new HashSet<BaseElement>();
        for (FlowElement element : allElements) {
            INBOUND_ELIGIBLE_TYPES.forEach(iet -> {
                if (iet.isInstance(element) && this.getRawProperties((BaseElement)element).containsKey("inbound.type")) {
                    inboundEligibleElements.add((BaseElement)element);
                }
            });
        }
        return inboundEligibleElements;
    }

    private Collection<FlowElement> retrieveEligibleElementsFromSubprocess(SubProcess subprocess) {
        HashSet<FlowElement> buffer = new HashSet<FlowElement>();
        Collection processFlowElements = subprocess.getFlowElements();
        return this.collectFlowElements(processFlowElements, buffer);
    }

    private Collection<FlowElement> collectFlowElements(Collection<FlowElement> processFlowElements, Collection<FlowElement> buffer) {
        for (FlowElement element : processFlowElements) {
            if (element instanceof SubProcess) {
                SubProcess subprocess = (SubProcess)element;
                buffer.addAll(this.retrieveEligibleElementsFromSubprocess(subprocess));
                continue;
            }
            buffer.add(element);
        }
        return buffer;
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForElement(BaseElement element, Process process, ProcessImportResult.ProcessDefinitionIdentifier identifier, ProcessImportResult.ProcessDefinitionVersion version) {
        try {
            if (element instanceof StartEvent) {
                StartEvent se = (StartEvent)element;
                return this.getCorrelationPointForStartEvent(se, process, version);
            }
            if (element instanceof IntermediateCatchEvent) {
                IntermediateCatchEvent ice = (IntermediateCatchEvent)element;
                return this.getCorrelationPointForIntermediateCatchEvent(ice);
            }
            if (element instanceof BoundaryEvent) {
                BoundaryEvent be = (BoundaryEvent)element;
                return this.getCorrelationPointForIntermediateBoundaryEvent(be);
            }
            if (element instanceof ReceiveTask) {
                ReceiveTask rt = (ReceiveTask)element;
                return this.getCorrelationPointForReceiveTask(rt);
            }
            LOG.warn("Unsupported Inbound element type: {}, in process definition: {} (Key: {}, Version: {})", new Object[]{element.getClass().getSimpleName(), identifier.bpmnProcessId(), version.processDefinitionKey(), version.version()});
        }
        catch (InvalidInboundConnectorDefinitionException e) {
            LOG.warn("Error getting correlation point for {} in process definition: {} (Key: {}, Version: {}): {}", new Object[]{element.getClass().getSimpleName(), identifier.bpmnProcessId(), version.processDefinitionKey(), version.version(), e.getMessage(), e});
        }
        return Optional.empty();
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForIntermediateCatchEvent(IntermediateCatchEvent intermediateCatchEvent) {
        return this.getCorrelationPointCatchEvent((CatchEvent)intermediateCatchEvent);
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForIntermediateBoundaryEvent(BoundaryEvent boundaryEvent) {
        return this.getCorrelationPointCatchEvent((CatchEvent)boundaryEvent);
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointCatchEvent(CatchEvent catchEvent) {
        MessageCorrelationPoint.StandaloneMessageCorrelationPoint correlationPoint;
        MessageEventDefinition msgDef = (MessageEventDefinition)catchEvent.getEventDefinitions().stream().filter(def -> def instanceof MessageEventDefinition).findAny().orElseThrow(() -> new InvalidInboundConnectorDefinitionException("Sanity check failed: " + catchEvent.getClass().getSimpleName() + " must contain at least one event definition"));
        String name = msgDef.getMessage().getName();
        String correlationKeyExpression = this.extractRequiredProperty((BaseElement)catchEvent, "correlationKeyExpression");
        String messageIdExpression = this.extractProperty((BaseElement)catchEvent, "messageIdExpression").orElse(null);
        Duration messageTtl = this.extractProperty((BaseElement)catchEvent, "messageTtl").map(Duration::parse).orElse(null);
        if (BoundaryEvent.class.isAssignableFrom(catchEvent.getClass())) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)catchEvent;
            Activity attachedTo = boundaryEvent.getAttachedTo();
            MessageCorrelationPoint.BoundaryEventCorrelationPoint.Activity activity = new MessageCorrelationPoint.BoundaryEventCorrelationPoint.Activity(attachedTo.getId(), attachedTo.getName());
            correlationPoint = new MessageCorrelationPoint.BoundaryEventCorrelationPoint(name, correlationKeyExpression, messageIdExpression, messageTtl, activity);
        } else {
            correlationPoint = new MessageCorrelationPoint.StandaloneMessageCorrelationPoint(name, correlationKeyExpression, messageIdExpression, messageTtl);
        }
        return Optional.of(correlationPoint);
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForStartEvent(StartEvent startEvent, Process process, ProcessImportResult.ProcessDefinitionVersion version) {
        MessageEventDefinition msgDef = startEvent.getEventDefinitions().stream().filter(def -> def instanceof MessageEventDefinition).findAny().orElse(null);
        if (msgDef != null) {
            String messageIdExpression = this.extractProperty((BaseElement)startEvent, "messageIdExpression").orElse(null);
            Duration messageTtl = this.extractProperty((BaseElement)startEvent, "messageTtl").map(Duration::parse).orElse(null);
            String correlationKeyExpression = this.extractProperty((BaseElement)startEvent, "correlationKeyExpression").orElse(null);
            return Optional.of(new MessageStartEventCorrelationPoint(msgDef.getMessage().getName(), messageIdExpression, messageTtl, correlationKeyExpression, process.getId(), version.version(), version.processDefinitionKey()));
        }
        return Optional.of(new StartEventCorrelationPoint(process.getId(), version.version(), version.processDefinitionKey()));
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForReceiveTask(ReceiveTask receiveTask) {
        Message message = receiveTask.getMessage();
        String correlationKeyExpression = this.extractRequiredProperty((BaseElement)receiveTask, "correlationKeyExpression");
        String messageIdExpression = this.extractProperty((BaseElement)receiveTask, "messageIdExpression").orElse(null);
        Duration messageTtl = this.extractProperty((BaseElement)receiveTask, "messageTtl").map(Duration::parse).orElse(null);
        return Optional.of(new MessageCorrelationPoint.StandaloneMessageCorrelationPoint(message.getName(), correlationKeyExpression, messageIdExpression, messageTtl));
    }

    private Map<String, String> getRawProperties(BaseElement element) {
        ZeebeProperties zeebeProperties = (ZeebeProperties)element.getSingleExtensionElement(ZeebeProperties.class);
        if (zeebeProperties == null) {
            return Collections.emptyMap();
        }
        return zeebeProperties.getProperties().stream().filter(property -> property.getValue() != null).collect(Collectors.toMap(ZeebeProperty::getName, ZeebeProperty::getValue, (oldValue, newValue) -> {
            LOG.warn("A duplicate has been found, old value {} and new value {} for element {}", new Object[]{oldValue, newValue, element.getId()});
            return oldValue;
        }));
    }

    private String extractRequiredProperty(BaseElement element, String name) {
        return this.extractProperty(element, name).orElseThrow(() -> new InvalidInboundConnectorDefinitionException("Missing required property " + name));
    }

    private Optional<String> extractProperty(BaseElement element, String name) {
        ZeebeProperties zeebeProperties = (ZeebeProperties)element.getSingleExtensionElement(ZeebeProperties.class);
        return Optional.ofNullable(zeebeProperties).map(ZeebeProperties::getProperties).flatMap(props -> props.stream().filter(property -> property.getName().equals(name)).findAny().map(ZeebeProperty::getValue));
    }

    static {
        INBOUND_ELIGIBLE_TYPES.add(StartEvent.class);
        INBOUND_ELIGIBLE_TYPES.add(IntermediateCatchEvent.class);
        INBOUND_ELIGIBLE_TYPES.add(ReceiveTask.class);
        INBOUND_ELIGIBLE_TYPES.add(BoundaryEvent.class);
    }
}

