/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.operate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.runtime.core.inbound.OperateClientAdapter;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.model.FlowNodeInstance;
import io.camunda.operate.model.FlowNodeInstanceState;
import io.camunda.operate.model.SearchResult;
import io.camunda.operate.model.Variable;
import io.camunda.operate.search.Filter;
import io.camunda.operate.search.FlowNodeInstanceFilter;
import io.camunda.operate.search.SearchQuery;
import io.camunda.operate.search.VariableFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class OperateClientAdapterImpl
implements OperateClientAdapter {
    private static final int PAGE_SIZE = 20;
    private final CamundaOperateClient camundaOperateClient;
    private final ObjectMapper mapper;
    private final Lock fetchActiveProcessLock;
    private final Lock fetchVariablesLock;

    public OperateClientAdapterImpl(CamundaOperateClient camundaOperateClient, ObjectMapper mapper) {
        this.camundaOperateClient = camundaOperateClient;
        this.mapper = mapper;
        this.fetchActiveProcessLock = new ReentrantLock();
        this.fetchVariablesLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowNodeInstance> fetchActiveProcessInstanceKeyByDefinitionKeyAndElementId(Long processDefinitionKey, String elementId) {
        this.fetchActiveProcessLock.lock();
        try {
            SearchResult searchResult;
            List processPaginationIndex = null;
            ArrayList<FlowNodeInstance> result = new ArrayList<FlowNodeInstance>();
            do {
                try {
                    FlowNodeInstanceFilter flownodeInstanceFilter = FlowNodeInstanceFilter.builder().processDefinitionKey(processDefinitionKey).flowNodeId(elementId).state(FlowNodeInstanceState.ACTIVE).build();
                    SearchQuery processInstanceQuery = new SearchQuery.Builder().filter((Filter)flownodeInstanceFilter).searchAfter(processPaginationIndex).size(Integer.valueOf(20)).build();
                    searchResult = this.camundaOperateClient.searchFlowNodeInstanceResults(processInstanceQuery);
                }
                catch (OperateException e) {
                    throw new RuntimeException(e);
                }
                processPaginationIndex = searchResult.getSortValues();
                if (searchResult.getItems() == null) continue;
                result.addAll(searchResult.getItems());
            } while (!CollectionUtils.isEmpty((Collection)searchResult.getItems()));
            ArrayList<FlowNodeInstance> arrayList = result;
            return arrayList;
        }
        finally {
            this.fetchActiveProcessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> fetchVariablesByProcessInstanceKey(Long processInstanceKey) {
        this.fetchVariablesLock.lock();
        try {
            SearchResult searchResult;
            List variablePaginationIndex = null;
            HashMap<String, Object> processVariables = new HashMap<String, Object>();
            do {
                try {
                    VariableFilter variableFilter = VariableFilter.builder().scopeKey(processInstanceKey).processInstanceKey(processInstanceKey).build();
                    SearchQuery variableQuery = new SearchQuery.Builder().filter((Filter)variableFilter).searchAfter(variablePaginationIndex).size(Integer.valueOf(20)).build();
                    searchResult = this.camundaOperateClient.searchVariableResults(variableQuery);
                }
                catch (OperateException e) {
                    throw new RuntimeException(e);
                }
                List newPaginationIdx = searchResult.getSortValues();
                if (searchResult.getItems() != null) {
                    processVariables.putAll(searchResult.getItems().stream().collect(Collectors.toMap(Variable::getName, variable -> this.unwrapValue(variable.getValue()))));
                }
                if (CollectionUtils.isEmpty((Collection)newPaginationIdx)) continue;
                variablePaginationIndex = newPaginationIdx;
            } while (!CollectionUtils.isEmpty((Collection)searchResult.getItems()));
            HashMap<String, Object> hashMap = processVariables;
            return hashMap;
        }
        finally {
            this.fetchVariablesLock.unlock();
        }
    }

    private Object unwrapValue(String wrappedValue) {
        try {
            JsonNode node = this.mapper.readTree(wrappedValue);
            if (node.isTextual()) {
                return node.textValue();
            }
            if (node.isNumber()) {
                return node.numberValue();
            }
            if (node.isArray()) {
                return this.mapper.readValue(wrappedValue, List.class);
            }
            if (node.isObject()) {
                return this.mapper.readValue(wrappedValue, Map.class);
            }
            if (node.isNull()) {
                return wrappedValue;
            }
            if (node.isBoolean()) {
                return node.booleanValue();
            }
        }
        catch (Exception e) {
            return wrappedValue;
        }
        return wrappedValue;
    }
}

