/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.executable;

import com.google.common.collect.EvictingQueue;
import io.camunda.connector.api.inbound.Health;
import io.camunda.connector.api.inbound.InboundConnectorContext;
import io.camunda.connector.api.inbound.InboundConnectorExecutable;
import io.camunda.connector.api.inbound.webhook.WebhookConnectorExecutable;
import io.camunda.connector.runtime.core.inbound.InboundConnectorContextFactory;
import io.camunda.connector.runtime.core.inbound.InboundConnectorFactory;
import io.camunda.connector.runtime.core.inbound.InboundConnectorReportingContext;
import io.camunda.connector.runtime.core.inbound.details.InboundConnectorDetails;
import io.camunda.connector.runtime.inbound.executable.RegisteredExecutable;
import io.camunda.connector.runtime.inbound.webhook.WebhookConnectorRegistry;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BatchExecutableProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(BatchExecutableProcessor.class);
    @Value(value="${camunda.connector.inbound.log.size:10}")
    private int inboundLogsSize;
    private final InboundConnectorFactory connectorFactory;
    private final InboundConnectorContextFactory connectorContextFactory;
    private final MetricsRecorder metricsRecorder;
    private final WebhookConnectorRegistry webhookConnectorRegistry;

    public BatchExecutableProcessor(InboundConnectorFactory connectorFactory, InboundConnectorContextFactory connectorContextFactory, @Autowired(required=false) MetricsRecorder metricsRecorder, @Autowired(required=false) WebhookConnectorRegistry webhookConnectorRegistry) {
        this.connectorFactory = connectorFactory;
        this.connectorContextFactory = connectorContextFactory;
        this.metricsRecorder = metricsRecorder;
        this.webhookConnectorRegistry = webhookConnectorRegistry;
    }

    public Map<UUID, RegisteredExecutable> activateBatch(Map<UUID, InboundConnectorDetails> request, BiConsumer<Throwable, UUID> cancellationCallback) {
        HashMap<UUID, RegisteredExecutable> alreadyActivated = new HashMap<UUID, RegisteredExecutable>();
        block6: for (Map.Entry<UUID, InboundConnectorDetails> entry : request.entrySet()) {
            RegisteredExecutable registeredExecutable;
            UUID id = entry.getKey();
            InboundConnectorDetails maybeValidData = entry.getValue();
            if (maybeValidData instanceof InboundConnectorDetails.InvalidInboundConnectorDetails) {
                InboundConnectorDetails.InvalidInboundConnectorDetails invalid = (InboundConnectorDetails.InvalidInboundConnectorDetails)maybeValidData;
                alreadyActivated.put(id, new RegisteredExecutable.InvalidDefinition(invalid, invalid.error().getMessage()));
                continue;
            }
            InboundConnectorDetails.ValidInboundConnectorDetails data = (InboundConnectorDetails.ValidInboundConnectorDetails)maybeValidData;
            RegisteredExecutable result = this.activateSingle((InboundConnectorDetails)data, e -> cancellationCallback.accept((Throwable)e, id));
            Objects.requireNonNull(result);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegisteredExecutable.Activated.class, RegisteredExecutable.ConnectorNotRegistered.class, RegisteredExecutable.InvalidDefinition.class, RegisteredExecutable.FailedToActivate.class}, (Object)registeredExecutable, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    RegisteredExecutable.Activated activated = (RegisteredExecutable.Activated)registeredExecutable;
                    alreadyActivated.put(id, activated);
                    continue block6;
                }
                case 1: {
                    RegisteredExecutable.ConnectorNotRegistered notRegistered = (RegisteredExecutable.ConnectorNotRegistered)registeredExecutable;
                    alreadyActivated.put(id, notRegistered);
                    continue block6;
                }
                case 2: {
                    RegisteredExecutable.InvalidDefinition invalid = (RegisteredExecutable.InvalidDefinition)registeredExecutable;
                    alreadyActivated.put(id, invalid);
                    continue block6;
                }
                case 3: 
            }
            RegisteredExecutable.FailedToActivate failed = (RegisteredExecutable.FailedToActivate)registeredExecutable;
            LOG.error("Failed to activate connector of type '{}' with deduplication ID '{}', reason: {}. All previously activated executables from this batch will be discarded.", new Object[]{failed.data().type(), failed.data().deduplicationId(), failed.reason()});
            this.deactivateBatch(new ArrayList<RegisteredExecutable>(alreadyActivated.values()));
            String failureReasonForOthers = "Process contains invalid connector(s): " + String.join((CharSequence)", ", failed.data().connectorElements().stream().map(e -> e.element().elementId()).toList()) + ". Reason: " + failed.reason();
            HashMap<UUID, RegisteredExecutable> notActivated = new HashMap<UUID, RegisteredExecutable>();
            for (Map.Entry<UUID, InboundConnectorDetails> failedEntry : request.entrySet()) {
                if (failedEntry.getKey().equals(id)) continue;
                notActivated.put(failedEntry.getKey(), new RegisteredExecutable.FailedToActivate(failedEntry.getValue(), failureReasonForOthers));
            }
            notActivated.put(id, failed);
            return notActivated;
        }
        return alreadyActivated;
    }

    private RegisteredExecutable activateSingle(InboundConnectorDetails data, Consumer<Throwable> cancellationCallback) {
        InboundConnectorReportingContext context;
        InboundConnectorExecutable executable;
        if (data instanceof InboundConnectorDetails.InvalidInboundConnectorDetails) {
            InboundConnectorDetails.InvalidInboundConnectorDetails invalid = (InboundConnectorDetails.InvalidInboundConnectorDetails)data;
            return new RegisteredExecutable.InvalidDefinition(invalid, invalid.error().getMessage());
        }
        InboundConnectorDetails.ValidInboundConnectorDetails validData = (InboundConnectorDetails.ValidInboundConnectorDetails)data;
        try {
            executable = (InboundConnectorExecutable)this.connectorFactory.getInstance(data.type());
            context = (InboundConnectorReportingContext)this.connectorContextFactory.createContext(validData, cancellationCallback, executable.getClass(), EvictingQueue.create((int)this.inboundLogsSize));
        }
        catch (NoSuchElementException e) {
            LOG.error("Failed to create executable", (Throwable)e);
            return new RegisteredExecutable.ConnectorNotRegistered(validData);
        }
        if (this.webhookConnectorRegistry == null && executable instanceof WebhookConnectorExecutable) {
            LOG.error("Webhook connector is not supported in this environment");
            context.reportHealth(Health.down((Throwable)new UnsupportedOperationException("Webhook connectors are not supported in this environment")));
            return new RegisteredExecutable.ConnectorNotRegistered(validData);
        }
        try {
            if (executable instanceof WebhookConnectorExecutable) {
                LOG.debug("Registering webhook: {}", (Object)data.type());
                this.webhookConnectorRegistry.register(new RegisteredExecutable.Activated(executable, context));
            }
            executable.activate((InboundConnectorContext)context);
        }
        catch (Exception e) {
            LOG.error("Failed to activate connector", (Throwable)e);
            return new RegisteredExecutable.FailedToActivate(data, e.getMessage());
        }
        LOG.info("Inbound connector {} activated with deduplication ID '{}'", (Object)data.type(), (Object)data.deduplicationId());
        if (this.metricsRecorder != null) {
            this.metricsRecorder.increase("camunda.connector.inbound.activations", "activated", data.type());
        }
        return new RegisteredExecutable.Activated(executable, context);
    }

    public void deactivateBatch(List<RegisteredExecutable> executables) {
        for (RegisteredExecutable activeExecutable : executables) {
            if (!(activeExecutable instanceof RegisteredExecutable.Activated)) continue;
            RegisteredExecutable.Activated activated = (RegisteredExecutable.Activated)activeExecutable;
            try {
                LOG.info("Deactivating executable: {}", (Object)activated.context().getDefinition().type());
                if (activated.executable() instanceof WebhookConnectorExecutable) {
                    LOG.debug("Unregistering webhook: {}", (Object)activated.context().getDefinition().type());
                    this.webhookConnectorRegistry.deregister(activated);
                }
                activated.executable().deactivate();
            }
            catch (Exception e) {
                LOG.error("Failed to deactivate executable", (Throwable)e);
            }
            if (this.metricsRecorder == null) continue;
            this.metricsRecorder.increase("camunda.connector.inbound.activations", "deactivated", activated.context().getDefinition().type());
        }
    }
}

