/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound;

import io.camunda.connector.api.inbound.CorrelationResult;
import io.camunda.connector.feel.FeelEngineWrapper;
import io.camunda.connector.runtime.core.inbound.InboundConnectorElement;
import io.camunda.connector.runtime.core.inbound.ProcessElementContextFactory;
import io.camunda.connector.runtime.core.inbound.correlation.InboundCorrelationHandler;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.time.Duration;
import java.util.List;

public class MeteredInboundCorrelationHandler
extends InboundCorrelationHandler {
    private final MetricsRecorder metricsRecorder;

    public MeteredInboundCorrelationHandler(ZeebeClient zeebeClient, FeelEngineWrapper feelEngine, MetricsRecorder metricsRecorder, ProcessElementContextFactory contextFactory, Duration messageTtl) {
        super(zeebeClient, feelEngine, contextFactory, messageTtl);
        this.metricsRecorder = metricsRecorder;
    }

    protected boolean isActivationConditionMet(InboundConnectorElement def, Object context) {
        boolean isConditionMet = super.isActivationConditionMet(def, context);
        if (!isConditionMet) {
            this.metricsRecorder.increase("camunda.connector.inbound.triggers", "activation-condition-failed", def.type());
        }
        return isConditionMet;
    }

    public CorrelationResult correlate(List<InboundConnectorElement> elementList, Object variables) {
        if (elementList.isEmpty()) {
            throw new IllegalArgumentException("No elements to correlate, potential API misuse");
        }
        String type = elementList.getFirst().type();
        this.metricsRecorder.increase("camunda.connector.inbound.triggers", "triggered", type);
        try {
            CorrelationResult result = super.correlate(elementList, variables);
            this.metricsRecorder.increase("camunda.connector.inbound.triggers", "correlated", type);
            return result;
        }
        catch (Exception e) {
            this.metricsRecorder.increase("camunda.connector.inbound.triggers", "correlation-failed", type);
            throw e;
        }
    }
}

