/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.generated.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.camunda.tasklist.generated.invoker.ApiClient;
import io.camunda.tasklist.generated.invoker.ApiException;
import io.camunda.tasklist.generated.invoker.BaseApi;
import io.camunda.tasklist.generated.invoker.Configuration;
import io.camunda.tasklist.generated.invoker.Pair;
import io.camunda.tasklist.generated.model.SaveVariablesRequest;
import io.camunda.tasklist.generated.model.TaskAssignRequest;
import io.camunda.tasklist.generated.model.TaskCompleteRequest;
import io.camunda.tasklist.generated.model.TaskResponse;
import io.camunda.tasklist.generated.model.TaskSearchRequest;
import io.camunda.tasklist.generated.model.TaskSearchResponse;
import io.camunda.tasklist.generated.model.VariableSearchResponse;
import io.camunda.tasklist.generated.model.VariablesSearchRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class TaskApi
extends BaseApi {
    public TaskApi() {
        super(Configuration.getDefaultApiClient());
    }

    public TaskApi(ApiClient apiClient) {
        super(apiClient);
    }

    public TaskResponse assignTask(String taskId, TaskAssignRequest taskAssignRequest) throws ApiException {
        return this.assignTask(taskId, taskAssignRequest, Collections.emptyMap());
    }

    public TaskResponse assignTask(String taskId, TaskAssignRequest taskAssignRequest, Map<String, String> additionalHeaders) throws ApiException {
        TaskAssignRequest localVarPostBody = taskAssignRequest;
        if (taskId == null) {
            throw new ApiException(400, "Missing the required parameter 'taskId' when calling assignTask");
        }
        String localVarPath = "/v1/tasks/{taskId}/assign".replaceAll("\\{taskId\\}", this.apiClient.escapeString(taskId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"cookie", "bearer-key"};
        TypeReference<TaskResponse> localVarReturnType = new TypeReference<TaskResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TaskResponse completeTask(String taskId, TaskCompleteRequest taskCompleteRequest) throws ApiException {
        return this.completeTask(taskId, taskCompleteRequest, Collections.emptyMap());
    }

    public TaskResponse completeTask(String taskId, TaskCompleteRequest taskCompleteRequest, Map<String, String> additionalHeaders) throws ApiException {
        TaskCompleteRequest localVarPostBody = taskCompleteRequest;
        if (taskId == null) {
            throw new ApiException(400, "Missing the required parameter 'taskId' when calling completeTask");
        }
        String localVarPath = "/v1/tasks/{taskId}/complete".replaceAll("\\{taskId\\}", this.apiClient.escapeString(taskId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"cookie", "bearer-key"};
        TypeReference<TaskResponse> localVarReturnType = new TypeReference<TaskResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TaskResponse getTaskById(String taskId) throws ApiException {
        return this.getTaskById(taskId, Collections.emptyMap());
    }

    public TaskResponse getTaskById(String taskId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (taskId == null) {
            throw new ApiException(400, "Missing the required parameter 'taskId' when calling getTaskById");
        }
        String localVarPath = "/v1/tasks/{taskId}".replaceAll("\\{taskId\\}", this.apiClient.escapeString(taskId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"cookie", "bearer-key"};
        TypeReference<TaskResponse> localVarReturnType = new TypeReference<TaskResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void saveDraftTaskVariables(String taskId, SaveVariablesRequest saveVariablesRequest) throws ApiException {
        this.saveDraftTaskVariables(taskId, saveVariablesRequest, Collections.emptyMap());
    }

    public void saveDraftTaskVariables(String taskId, SaveVariablesRequest saveVariablesRequest, Map<String, String> additionalHeaders) throws ApiException {
        SaveVariablesRequest localVarPostBody = saveVariablesRequest;
        if (taskId == null) {
            throw new ApiException(400, "Missing the required parameter 'taskId' when calling saveDraftTaskVariables");
        }
        if (saveVariablesRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'saveVariablesRequest' when calling saveDraftTaskVariables");
        }
        String localVarPath = "/v1/tasks/{taskId}/variables".replaceAll("\\{taskId\\}", this.apiClient.escapeString(taskId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"*/*", "application/problem+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"cookie", "bearer-key"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<VariableSearchResponse> searchTaskVariables(String taskId, VariablesSearchRequest variablesSearchRequest) throws ApiException {
        return this.searchTaskVariables(taskId, variablesSearchRequest, Collections.emptyMap());
    }

    public List<VariableSearchResponse> searchTaskVariables(String taskId, VariablesSearchRequest variablesSearchRequest, Map<String, String> additionalHeaders) throws ApiException {
        VariablesSearchRequest localVarPostBody = variablesSearchRequest;
        if (taskId == null) {
            throw new ApiException(400, "Missing the required parameter 'taskId' when calling searchTaskVariables");
        }
        String localVarPath = "/v1/tasks/{taskId}/variables/search".replaceAll("\\{taskId\\}", this.apiClient.escapeString(taskId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"cookie", "bearer-key"};
        TypeReference<List<VariableSearchResponse>> localVarReturnType = new TypeReference<List<VariableSearchResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TaskSearchResponse> searchTasks(TaskSearchRequest taskSearchRequest) throws ApiException {
        return this.searchTasks(taskSearchRequest, Collections.emptyMap());
    }

    public List<TaskSearchResponse> searchTasks(TaskSearchRequest taskSearchRequest, Map<String, String> additionalHeaders) throws ApiException {
        TaskSearchRequest localVarPostBody = taskSearchRequest;
        String localVarPath = "/v1/tasks/search";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"cookie", "bearer-key"};
        TypeReference<List<TaskSearchResponse>> localVarReturnType = new TypeReference<List<TaskSearchResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TaskResponse unassignTask(String taskId) throws ApiException {
        return this.unassignTask(taskId, Collections.emptyMap());
    }

    public TaskResponse unassignTask(String taskId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (taskId == null) {
            throw new ApiException(400, "Missing the required parameter 'taskId' when calling unassignTask");
        }
        String localVarPath = "/v1/tasks/{taskId}/unassign".replaceAll("\\{taskId\\}", this.apiClient.escapeString(taskId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"cookie", "bearer-key"};
        TypeReference<TaskResponse> localVarReturnType = new TypeReference<TaskResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"cookie", "bearer-key"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

