/*
 * Tasklist REST API
 * Tasklist is a ready-to-use API application to rapidly implement business processes alongside user tasks in Zeebe.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.tasklist.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.tasklist.generated.model.IncludeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Request object to search tasks variables by provided variable names.
 */
@JsonPropertyOrder({
  VariablesSearchRequest.JSON_PROPERTY_VARIABLE_NAMES,
  VariablesSearchRequest.JSON_PROPERTY_INCLUDE_VARIABLES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-12-10T08:37:54.906726Z[Etc/UTC]", comments = "Generator version: 7.8.0")
public class VariablesSearchRequest {
  public static final String JSON_PROPERTY_VARIABLE_NAMES = "variableNames";
  private List<String> variableNames;

  public static final String JSON_PROPERTY_INCLUDE_VARIABLES = "includeVariables";
  private List<IncludeVariable> includeVariables;

  public VariablesSearchRequest() {
  }

  public VariablesSearchRequest variableNames(List<String> variableNames) {
    
    this.variableNames = variableNames;
    return this;
  }

  public VariablesSearchRequest addVariableNamesItem(String variableNamesItem) {
    if (this.variableNames == null) {
      this.variableNames = new ArrayList<>();
    }
    this.variableNames.add(variableNamesItem);
    return this;
  }

  /**
   * Names of variables to find.
   * @return variableNames
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getVariableNames() {
    return variableNames;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariableNames(List<String> variableNames) {
    this.variableNames = variableNames;
  }

  public VariablesSearchRequest includeVariables(List<IncludeVariable> includeVariables) {
    
    this.includeVariables = includeVariables;
    return this;
  }

  public VariablesSearchRequest addIncludeVariablesItem(IncludeVariable includeVariablesItem) {
    if (this.includeVariables == null) {
      this.includeVariables = new ArrayList<>();
    }
    this.includeVariables.add(includeVariablesItem);
    return this;
  }

  /**
   * An array of variable names that should be included in the response.
   * @return includeVariables
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCLUDE_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IncludeVariable> getIncludeVariables() {
    return includeVariables;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeVariables(List<IncludeVariable> includeVariables) {
    this.includeVariables = includeVariables;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VariablesSearchRequest variablesSearchRequest = (VariablesSearchRequest) o;
    return Objects.equals(this.variableNames, variablesSearchRequest.variableNames) &&
        Objects.equals(this.includeVariables, variablesSearchRequest.includeVariables);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variableNames, includeVariables);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VariablesSearchRequest {\n");
    sb.append("    variableNames: ").append(toIndentedString(variableNames)).append("\n");
    sb.append("    includeVariables: ").append(toIndentedString(includeVariables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `variableNames` to the URL query string
    if (getVariableNames() != null) {
      for (int i = 0; i < getVariableNames().size(); i++) {
        try {
          joiner.add(String.format("%svariableNames%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getVariableNames().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `includeVariables` to the URL query string
    if (getIncludeVariables() != null) {
      for (int i = 0; i < getIncludeVariables().size(); i++) {
        if (getIncludeVariables().get(i) != null) {
          joiner.add(getIncludeVariables().get(i).toUrlQueryString(String.format("%sincludeVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

