/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.sort;

import io.camunda.search.clients.sort.SearchSortOptions;
import io.camunda.search.clients.sort.SortOptionsBuilders;
import io.camunda.search.clients.sort.SortOrder;
import io.camunda.service.search.sort.SortOption;
import io.camunda.service.transformers.ServiceTransformer;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class FieldSortingTransformer
implements ServiceTransformer<Tuple<List<SortOption.FieldSorting>, Boolean>, List<SearchSortOptions>> {
    private static final SearchSortOptions DEFAULT_SORT_BY_KEY_ASC = SortOptionsBuilders.sortOptions((String)"key", (SortOrder)SortOrder.ASC);
    private static final SearchSortOptions DEFAULT_SORT_BY_KEY_DESC = SortOptionsBuilders.sortOptions((String)"key", (SortOrder)SortOrder.DESC);

    @Override
    public List<SearchSortOptions> apply(Tuple<List<SortOption.FieldSorting>, Boolean> value) {
        List orderings = (List)value.getLeft();
        Boolean reverse = (Boolean)value.getRight();
        List<SearchSortOptions> sorting = this.map(orderings, reverse);
        SearchSortOptions defaultSorting = this.getDefaultSearchSortOption(reverse);
        sorting.add(defaultSorting);
        return sorting;
    }

    private List<SearchSortOptions> map(List<SortOption.FieldSorting> orderings, boolean reverse) {
        List<Object> sorting = orderings != null && !orderings.isEmpty() ? orderings.stream().map(f -> this.toSearchSortOption((SortOption.FieldSorting)f, reverse)).collect(Collectors.toList()) : new ArrayList<SearchSortOptions>();
        return sorting;
    }

    private SearchSortOptions toSearchSortOption(SortOption.FieldSorting value, boolean reverse) {
        String field = value.field();
        SortOrder order = value.order();
        if (!reverse) {
            return SortOptionsBuilders.sortOptions((String)field, (SortOrder)order, (String)"_last");
        }
        return SortOptionsBuilders.sortOptions((String)field, (SortOrder)SortOptionsBuilders.reverseOrder((SortOrder)order), (String)"_first");
    }

    private SearchSortOptions getDefaultSearchSortOption(boolean reverse) {
        if (!reverse) {
            return DEFAULT_SORT_BY_KEY_ASC;
        }
        return DEFAULT_SORT_BY_KEY_DESC;
    }
}

