/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchMatchQuery;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.service.search.filter.DateValueFilter;
import io.camunda.service.search.filter.ProcessInstanceFilter;
import io.camunda.service.search.filter.ProcessInstanceVariableFilter;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.service.transformers.filter.DateValueFilterTransformer;
import io.camunda.service.transformers.filter.FilterTransformer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class ProcessInstanceFilterTransformer
implements FilterTransformer<ProcessInstanceFilter> {
    private static final String WILD_CARD = "*";
    private final ServiceTransformers transformers;

    public ProcessInstanceFilterTransformer(ServiceTransformers transformers) {
        this.transformers = transformers;
    }

    @Override
    public SearchQuery toSearchQuery(ProcessInstanceFilter filter) {
        SearchQuery isProcessInstanceQuery = this.getIsProcessInstanceQuery();
        SearchQuery runningFinishedQuery = this.getRunningFinishedQuery(filter);
        SearchQuery retriesLeftQuery = this.getRetriesLeftQuery(filter.retriesLeft());
        SearchQuery errorMessageQuery = this.getErrorMessageQuery(filter.errorMessage());
        SearchQuery activityIdQuery = this.getActivityIdQuery(filter);
        SearchQuery startDateQuery = this.getStartDateQuery(filter.startDate());
        SearchQuery endDateQuery = this.getEndDateQuery(filter.endDate());
        SearchQuery bpmnProcessIdsQuery = this.getBpmnProcessIdsQuery(filter.bpmnProcessIds());
        SearchQuery processDefinitionVersionsQuery = this.getProcessDefinitionVersionsQuery(filter.processDefinitionVersions());
        SearchQuery variableQuery = this.getProcessInstanceVariableQuery(filter.variable());
        SearchQuery batchOperationIdsQuery = this.getBatchOperationIdsQuery(filter.batchOperationIds());
        SearchQuery parentProcessInstanceKeys = this.getParentProcessInstanceKeysQuery(filter.parentProcessInstanceKeys());
        SearchQuery tenantIdsQuery = this.getTenantIdsQuery(filter.tenantIds());
        return SearchQueryBuilders.and((SearchQuery)isProcessInstanceQuery, (SearchQuery[])new SearchQuery[]{runningFinishedQuery, retriesLeftQuery, errorMessageQuery, activityIdQuery, startDateQuery, endDateQuery, bpmnProcessIdsQuery, processDefinitionVersionsQuery, variableQuery, batchOperationIdsQuery, parentProcessInstanceKeys, tenantIdsQuery});
    }

    private SearchQuery getIsProcessInstanceQuery() {
        return SearchQueryBuilders.term((String)"joinRelation", (String)"processInstance");
    }

    private SearchQuery getRunningFinishedQuery(ProcessInstanceFilter filter) {
        SearchQuery processInstanceQuery;
        boolean running = filter.running();
        boolean active = filter.active();
        boolean incidents = filter.incidents();
        boolean finished = filter.finished();
        boolean completed = filter.completed();
        boolean canceled = filter.canceled();
        if (!running && !finished) {
            return SearchQueryBuilders.matchNone();
        }
        if (running && active && incidents && finished && completed && canceled) {
            return null;
        }
        SearchQuery runningQuery = null;
        if (running && (active || incidents)) {
            runningQuery = SearchQueryBuilders.not((SearchQuery)SearchQueryBuilders.exists((String)"endDate"), (SearchQuery[])new SearchQuery[0]);
            SearchQuery activeQuery = this.getActiveQuery(active);
            SearchQuery incidentsQuery = this.getIncidentsQuery(incidents);
            if (filter.activityId() != null || !filter.active() || !filter.incidents()) {
                runningQuery = SearchQueryBuilders.and((SearchQuery)runningQuery, (SearchQuery[])new SearchQuery[]{SearchQueryBuilders.or((SearchQuery)activeQuery, (SearchQuery[])new SearchQuery[]{incidentsQuery})});
            }
        }
        SearchQuery finishedQuery = null;
        if (finished && (completed || canceled)) {
            finishedQuery = SearchQueryBuilders.exists((String)"endDate");
            SearchQuery completedQuery = this.getCompletedQuery(completed);
            SearchQuery canceledQuery = this.getCanceledQuery(canceled);
            if (filter.activityId() != null || !filter.completed() || !filter.canceled()) {
                finishedQuery = SearchQueryBuilders.and((SearchQuery)finishedQuery, (SearchQuery[])new SearchQuery[]{SearchQueryBuilders.or((SearchQuery)completedQuery, (SearchQuery[])new SearchQuery[]{canceledQuery})});
            }
        }
        if ((processInstanceQuery = SearchQueryBuilders.or((SearchQuery)runningQuery, (SearchQuery[])new SearchQuery[]{finishedQuery})) == null) {
            return SearchQueryBuilders.matchNone();
        }
        return processInstanceQuery;
    }

    private SearchQuery getActiveQuery(boolean active) {
        if (active) {
            return SearchQueryBuilders.term((String)"incident", (boolean)false);
        }
        return null;
    }

    private SearchQuery getIncidentsQuery(boolean incidents) {
        if (incidents) {
            return SearchQueryBuilders.term((String)"incident", (boolean)true);
        }
        return null;
    }

    private SearchQuery getCompletedQuery(boolean completed) {
        if (completed) {
            return SearchQueryBuilders.term((String)"state", (String)"COMPLETED");
        }
        return null;
    }

    private SearchQuery getCanceledQuery(boolean canceled) {
        if (canceled) {
            return SearchQueryBuilders.term((String)"state", (String)"CANCELED");
        }
        return null;
    }

    private SearchQuery getRetriesLeftQuery(boolean retriesLeft) {
        if (retriesLeft) {
            SearchQuery retriesLeftQuery = SearchQueryBuilders.term((String)"jobFailedWithRetriesLeft", (boolean)true);
            return SearchQueryBuilders.hasChildQuery((String)"activity", (SearchQuery)retriesLeftQuery);
        }
        return null;
    }

    private SearchQuery getErrorMessageQuery(String errorMessage) {
        if (StringUtils.isEmpty((CharSequence)errorMessage)) {
            return null;
        }
        if (errorMessage.contains(WILD_CARD)) {
            return this.getErrorMessageAsWildcardQuery(errorMessage.toLowerCase());
        }
        return this.getErrorMessageAsAndMatchQuery(errorMessage);
    }

    private SearchQuery getErrorMessageAsWildcardQuery(String errorMessage) {
        return SearchQueryBuilders.hasChildQuery((String)"activity", (SearchQuery)SearchQueryBuilders.wildcardQuery((String)"errorMessage", (String)errorMessage));
    }

    private SearchQuery getErrorMessageAsAndMatchQuery(String errorMessage) {
        return SearchQueryBuilders.hasChildQuery((String)"activity", (SearchQuery)SearchQueryBuilders.match((String)"errorMessage", (String)errorMessage, (SearchMatchQuery.SearchMatchQueryOperator)SearchMatchQuery.SearchMatchQueryOperator.AND));
    }

    private SearchQuery getActivityIdQuery(ProcessInstanceFilter filter) {
        String activityId = filter.activityId();
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            return null;
        }
        SearchQuery activeActivityIdQuery = null;
        if (filter.active()) {
            activeActivityIdQuery = this.createActivityIdQuery(activityId, "ACTIVE");
        }
        SearchQuery incidentActivityIdQuery = null;
        if (filter.incidents()) {
            incidentActivityIdQuery = this.createActivityIdIncidentQuery(activityId);
        }
        SearchQuery completedActivityIdQuery = null;
        if (filter.completed()) {
            completedActivityIdQuery = this.createActivityIdQuery(activityId, "COMPLETED");
        }
        SearchQuery canceledActivityIdQuery = null;
        if (filter.canceled()) {
            canceledActivityIdQuery = this.createActivityIdQuery(activityId, "TERMINATED");
        }
        return SearchQueryBuilders.or((SearchQuery)activeActivityIdQuery, (SearchQuery[])new SearchQuery[]{incidentActivityIdQuery, completedActivityIdQuery, canceledActivityIdQuery});
    }

    private SearchQuery createActivityIdQuery(String activityId, String flowNodeState) {
        SearchQuery activitiesQuery = SearchQueryBuilders.term((String)"activityState", (String)flowNodeState);
        SearchQuery activityIdQuery = SearchQueryBuilders.term((String)"activityId", (String)activityId);
        SearchQuery activityIsEndNodeQuery = null;
        if (Objects.equals(flowNodeState, "COMPLETED")) {
            activityIsEndNodeQuery = SearchQueryBuilders.term((String)"activityType", (String)"END_EVENT");
        }
        return SearchQueryBuilders.hasChildQuery((String)"activity", (SearchQuery)SearchQueryBuilders.and((SearchQuery)activitiesQuery, (SearchQuery[])new SearchQuery[]{activityIdQuery, activityIsEndNodeQuery}));
    }

    private SearchQuery createActivityIdIncidentQuery(String activityId) {
        SearchQuery activitiesQuery = SearchQueryBuilders.term((String)"activityState", (String)"ACTIVE");
        SearchQuery activityIdQuery = SearchQueryBuilders.term((String)"activityId", (String)activityId);
        SearchQuery incidentExists = SearchQueryBuilders.exists((String)"errorMessage");
        return SearchQueryBuilders.hasChildQuery((String)"activity", (SearchQuery)SearchQueryBuilders.and((SearchQuery)activitiesQuery, (SearchQuery[])new SearchQuery[]{activityIdQuery, incidentExists}));
    }

    private SearchQuery getStartDateQuery(DateValueFilter filter) {
        if (filter != null) {
            FilterTransformer<DateValueFilterTransformer.DateFieldFilter> transformer = this.getDateValueFilterTransformer();
            return transformer.apply(new DateValueFilterTransformer.DateFieldFilter("startDate", filter));
        }
        return null;
    }

    private SearchQuery getEndDateQuery(DateValueFilter filter) {
        if (filter != null) {
            FilterTransformer<DateValueFilterTransformer.DateFieldFilter> transformer = this.getDateValueFilterTransformer();
            return transformer.apply(new DateValueFilterTransformer.DateFieldFilter("endDate", filter));
        }
        return null;
    }

    private FilterTransformer<DateValueFilterTransformer.DateFieldFilter> getDateValueFilterTransformer() {
        return this.transformers.getFilterTransformer(DateValueFilter.class);
    }

    private SearchQuery getBpmnProcessIdsQuery(List<String> bpmnProcessIds) {
        return SearchQueryBuilders.stringTerms((String)"bpmnProcessId", bpmnProcessIds);
    }

    private SearchQuery getProcessDefinitionVersionsQuery(List<Integer> processDefinitionVersions) {
        return SearchQueryBuilders.intTerms((String)"processVersion", processDefinitionVersions);
    }

    private SearchQuery getProcessInstanceVariableQuery(ProcessInstanceVariableFilter variable) {
        if (variable != null) {
            SearchQuery query = SearchQueryBuilders.and((SearchQuery)SearchQueryBuilders.term((String)"varName", (String)variable.name()), (SearchQuery[])new SearchQuery[]{SearchQueryBuilders.stringTerms((String)"varValue", variable.values())});
            return SearchQueryBuilders.hasChildQuery((String)"variable", (SearchQuery)query);
        }
        return null;
    }

    private SearchQuery getBatchOperationIdsQuery(List<String> batchOperationIds) {
        return SearchQueryBuilders.stringTerms((String)"batchOperationIds", batchOperationIds);
    }

    private SearchQuery getParentProcessInstanceKeysQuery(List<Long> parentProcessInstanceKeys) {
        return SearchQueryBuilders.longTerms((String)"parentProcessInstanceKey", parentProcessInstanceKeys);
    }

    private SearchQuery getTenantIdsQuery(List<String> tenantIds) {
        return SearchQueryBuilders.stringTerms((String)"tenantId", tenantIds);
    }

    @Override
    public List<String> toIndices(ProcessInstanceFilter filter) {
        boolean finished = filter.finished();
        boolean completed = filter.completed();
        boolean canceled = filter.canceled();
        if (finished || completed || canceled) {
            return Arrays.asList("operate-list-view-8.3.0_alias");
        }
        return Arrays.asList("operate-list-view-8.3.0_");
    }
}

