/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.query;

import io.camunda.service.search.filter.DecisionInstanceFilter;
import io.camunda.service.search.filter.FilterBuilders;
import io.camunda.service.search.page.SearchQueryPage;
import io.camunda.service.search.query.SearchQueryBase;
import io.camunda.service.search.query.TypedSearchQuery;
import io.camunda.service.search.query.TypedSearchQueryBuilder;
import io.camunda.service.search.result.DecisionInstanceQueryResultConfig;
import io.camunda.service.search.result.QueryResultConfigBuilders;
import io.camunda.service.search.sort.DecisionInstanceSort;
import io.camunda.service.search.sort.SortOptionBuilders;
import io.camunda.util.ObjectBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;

public final class DecisionInstanceQuery
extends Record
implements TypedSearchQuery<DecisionInstanceFilter, DecisionInstanceSort> {
    private final DecisionInstanceFilter filter;
    private final DecisionInstanceSort sort;
    private final SearchQueryPage page;
    private final DecisionInstanceQueryResultConfig resultConfig;

    public DecisionInstanceQuery(DecisionInstanceFilter filter, DecisionInstanceSort sort, SearchQueryPage page, DecisionInstanceQueryResultConfig resultConfig) {
        this.filter = filter;
        this.sort = sort;
        this.page = page;
        this.resultConfig = resultConfig;
    }

    public static DecisionInstanceQuery of(Function<Builder, ObjectBuilder<DecisionInstanceQuery>> fn) {
        return (DecisionInstanceQuery)fn.apply(new Builder()).build();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DecisionInstanceQuery.class, "filter;sort;page;resultConfig", "filter", "sort", "page", "resultConfig"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DecisionInstanceQuery.class, "filter;sort;page;resultConfig", "filter", "sort", "page", "resultConfig"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DecisionInstanceQuery.class, "filter;sort;page;resultConfig", "filter", "sort", "page", "resultConfig"}, this, o);
    }

    @Override
    public DecisionInstanceFilter filter() {
        return this.filter;
    }

    @Override
    public DecisionInstanceSort sort() {
        return this.sort;
    }

    @Override
    public SearchQueryPage page() {
        return this.page;
    }

    @Override
    public DecisionInstanceQueryResultConfig resultConfig() {
        return this.resultConfig;
    }

    public static final class Builder
    extends SearchQueryBase.AbstractQueryBuilder<Builder>
    implements TypedSearchQueryBuilder<DecisionInstanceQuery, Builder, DecisionInstanceFilter, DecisionInstanceSort> {
        private static final DecisionInstanceFilter EMPTY_FILTER = FilterBuilders.decisionInstance().build();
        private static final DecisionInstanceSort EMPTY_SORT = SortOptionBuilders.decisionInstance().build();
        private static final DecisionInstanceQueryResultConfig DEFAULT_RESULT_CONFIG = QueryResultConfigBuilders.decisionInstance(r -> (ObjectBuilder)((DecisionInstanceQueryResultConfig.Builder)r.evaluatedInputs().exclude()).evaluatedOutputs().exclude());
        private DecisionInstanceFilter filter;
        private DecisionInstanceSort sort;
        private DecisionInstanceQueryResultConfig resultConfig;

        @Override
        public Builder filter(DecisionInstanceFilter value) {
            this.filter = value;
            return this;
        }

        @Override
        public Builder sort(DecisionInstanceSort value) {
            this.sort = value;
            return this;
        }

        public Builder resultConfig(DecisionInstanceQueryResultConfig value) {
            this.resultConfig = value;
            return this;
        }

        @Override
        public Builder filter(Function<DecisionInstanceFilter.Builder, ObjectBuilder<DecisionInstanceFilter>> fn) {
            return this.filter(FilterBuilders.decisionInstance(fn));
        }

        @Override
        public Builder sort(Function<DecisionInstanceSort.Builder, ObjectBuilder<DecisionInstanceSort>> fn) {
            return this.sort(SortOptionBuilders.decisionInstance(fn));
        }

        public Builder resultConfig(Function<DecisionInstanceQueryResultConfig.Builder, ObjectBuilder<DecisionInstanceQueryResultConfig>> fn) {
            return this.resultConfig(QueryResultConfigBuilders.decisionInstance(fn));
        }

        @Override
        protected Builder self() {
            return this;
        }

        public DecisionInstanceQuery build() {
            this.filter = Objects.requireNonNullElse(this.filter, EMPTY_FILTER);
            this.sort = Objects.requireNonNullElse(this.sort, EMPTY_SORT);
            this.resultConfig = Objects.requireNonNullElse(this.resultConfig, DEFAULT_RESULT_CONFIG);
            return new DecisionInstanceQuery(this.filter, this.sort, this.page(), this.resultConfig);
        }
    }
}

