/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.filter;

import io.camunda.service.search.filter.FilterBase;
import io.camunda.service.search.filter.VariableValueFilter;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public record VariableFilter(List<VariableValueFilter> variableFilters, List<Long> scopeKeys, List<Long> processInstanceKeys, boolean orConditions, boolean onlyRuntimeVariables) implements FilterBase
{

    public static final class Builder
    implements ObjectBuilder<VariableFilter> {
        private List<VariableValueFilter> variableFilters;
        private List<Long> scopeKeys;
        private List<Long> processInstanceKeys;
        private boolean orConditions;
        private boolean onlyRuntimeVariables;

        public Builder variable(List<VariableValueFilter> values) {
            this.variableFilters = CollectionUtil.addValuesToList(this.variableFilters, values);
            return this;
        }

        public Builder variable(VariableValueFilter value, VariableValueFilter ... values) {
            return this.variable(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder variable(Function<VariableValueFilter.Builder, ObjectBuilder<VariableValueFilter>> fn) {
            return this.variable((VariableValueFilter)fn.apply(new VariableValueFilter.Builder()).build(), new VariableValueFilter[0]);
        }

        public Builder scopeKeys(Long value, Long ... values) {
            return this.scopeKeys(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder scopeKeys(List<Long> values) {
            this.scopeKeys = CollectionUtil.addValuesToList(this.scopeKeys, values);
            return this;
        }

        public Builder processInstanceKeys(Long value, Long ... values) {
            return this.processInstanceKeys(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder processInstanceKeys(List<Long> values) {
            this.processInstanceKeys = CollectionUtil.addValuesToList(this.processInstanceKeys, values);
            return this;
        }

        public Builder orConditions(boolean orConditions) {
            this.orConditions = orConditions;
            return this;
        }

        public Builder onlyRuntimeVariables(boolean onlyRuntimeVariables) {
            this.onlyRuntimeVariables = onlyRuntimeVariables;
            return this;
        }

        public VariableFilter build() {
            return new VariableFilter(Objects.requireNonNullElseGet(this.variableFilters, Collections::emptyList), Objects.requireNonNullElseGet(this.scopeKeys, Collections::emptyList), Objects.requireNonNullElseGet(this.processInstanceKeys, Collections::emptyList), this.orConditions, this.onlyRuntimeVariables);
        }
    }
}

