/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.filter;

import io.camunda.service.search.filter.DateValueFilter;
import io.camunda.service.search.filter.FilterBase;
import io.camunda.service.search.filter.FilterBuilders;
import io.camunda.service.search.filter.ProcessInstanceVariableFilter;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public record ProcessInstanceFilter(boolean running, boolean active, boolean incidents, boolean finished, boolean completed, boolean canceled, boolean retriesLeft, String errorMessage, String activityId, DateValueFilter startDate, DateValueFilter endDate, List<String> bpmnProcessIds, List<Integer> processDefinitionVersions, ProcessInstanceVariableFilter variable, List<String> batchOperationIds, List<Long> parentProcessInstanceKeys, List<String> tenantIds) implements FilterBase
{

    public static final class Builder
    implements ObjectBuilder<ProcessInstanceFilter> {
        private boolean running;
        private boolean active;
        private boolean incidents;
        private boolean finished;
        private boolean completed;
        private boolean canceled;
        private boolean retriesLeft;
        private String errorMessage;
        private String activityId;
        private DateValueFilter startDate;
        private DateValueFilter endDate;
        private List<String> bpmnProcessIds;
        private List<Integer> processDefinitionVersions;
        private ProcessInstanceVariableFilter variable;
        private List<String> batchOperationIds;
        private List<Long> parentProcessInstanceKeys;
        private List<String> tenantIds;

        public Builder running(boolean running) {
            this.running = running;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder incidents(boolean incidents) {
            this.incidents = incidents;
            return this;
        }

        public Builder finished(boolean finished) {
            this.finished = finished;
            return this;
        }

        public Builder completed(boolean completed) {
            this.completed = completed;
            return this;
        }

        public Builder canceled(boolean canceled) {
            this.canceled = canceled;
            return this;
        }

        public Builder retriesLeft(boolean retriesLeft) {
            this.retriesLeft = retriesLeft;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public Builder startDate(DateValueFilter startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder startDate(Function<DateValueFilter.Builder, ObjectBuilder<DateValueFilter>> fn) {
            return this.startDate(FilterBuilders.dateValue(fn));
        }

        public Builder endDate(DateValueFilter endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder endDate(Function<DateValueFilter.Builder, ObjectBuilder<DateValueFilter>> fn) {
            return this.endDate(FilterBuilders.dateValue(fn));
        }

        public Builder bpmnProcessIds(List<String> values) {
            this.bpmnProcessIds = CollectionUtil.addValuesToList(this.bpmnProcessIds, values);
            return this;
        }

        public Builder bpmnProcessIds(String ... values) {
            return this.bpmnProcessIds(CollectionUtil.collectValuesAsList((Object[])values));
        }

        public Builder processDefinitionVersions(List<Integer> values) {
            this.processDefinitionVersions = CollectionUtil.addValuesToList(this.processDefinitionVersions, values);
            return this;
        }

        public Builder processDefinitionVersions(Integer ... values) {
            return this.processDefinitionVersions(CollectionUtil.collectValuesAsList((Object[])values));
        }

        public Builder variable(ProcessInstanceVariableFilter variable) {
            this.variable = variable;
            return this;
        }

        public Builder variable(Function<ProcessInstanceVariableFilter.Builder, ObjectBuilder<ProcessInstanceVariableFilter>> fn) {
            return this.variable(FilterBuilders.processInstanceVariable(fn));
        }

        public Builder batchOperationIds(List<String> values) {
            this.batchOperationIds = CollectionUtil.addValuesToList(this.batchOperationIds, values);
            return this;
        }

        public Builder batchOperationIds(String ... values) {
            return this.batchOperationIds(CollectionUtil.collectValuesAsList((Object[])values));
        }

        public Builder parentProcessInstanceKeys(List<Long> values) {
            this.parentProcessInstanceKeys = CollectionUtil.addValuesToList(this.parentProcessInstanceKeys, values);
            return this;
        }

        public Builder parentProcessInstanceKeys(Long ... values) {
            return this.parentProcessInstanceKeys(CollectionUtil.collectValuesAsList((Object[])values));
        }

        public Builder tenantIds(List<String> values) {
            this.tenantIds = CollectionUtil.addValuesToList(this.tenantIds, values);
            return this;
        }

        public Builder tenantIds(String ... values) {
            return this.tenantIds(CollectionUtil.collectValuesAsList((Object[])values));
        }

        public ProcessInstanceFilter build() {
            return new ProcessInstanceFilter(this.running, this.active, this.incidents, this.finished, this.completed, this.canceled, this.retriesLeft, this.errorMessage, this.activityId, this.startDate, this.endDate, Objects.requireNonNullElse(this.bpmnProcessIds, Collections.emptyList()), Objects.requireNonNullElse(this.processDefinitionVersions, Collections.emptyList()), this.variable, Objects.requireNonNullElse(this.batchOperationIds, Collections.emptyList()), Objects.requireNonNullElse(this.parentProcessInstanceKeys, Collections.emptyList()), Objects.requireNonNullElse(this.tenantIds, Collections.emptyList()));
        }
    }
}

