/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.ApiServices;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerCorrelateMessageRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerPublishMessageRequest;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageCorrelationRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class MessageServices
extends ApiServices<MessageServices> {
    public MessageServices(BrokerClient brokerClient, CamundaSearchClient searchClient) {
        this(brokerClient, searchClient, null, null);
    }

    public MessageServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public MessageServices withAuthentication(Authentication authentication) {
        return new MessageServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    public CompletableFuture<MessageCorrelationRecord> correlateMessage(CorrelateMessageRequest correlationRequest) {
        BrokerCorrelateMessageRequest brokerRequest = new BrokerCorrelateMessageRequest(correlationRequest.name, correlationRequest.correlationKey).setVariables(this.getDocumentOrEmpty(correlationRequest.variables)).setTenantId(correlationRequest.tenantId);
        return this.sendBrokerRequest(brokerRequest);
    }

    public CompletableFuture<BrokerResponse<MessageRecord>> publishMessage(PublicationMessageRequest request) {
        BrokerPublishMessageRequest brokerRequest = new BrokerPublishMessageRequest(request.name, request.correlationKey).setTimeToLive(request.timeToLive.longValue()).setMessageId(request.messageId).setVariables(this.getDocumentOrEmpty(request.variables)).setTenantId(request.tenantId);
        return this.sendBrokerRequestWithFullResponse(brokerRequest);
    }

    public record CorrelateMessageRequest(String name, String correlationKey, Map<String, Object> variables, String tenantId) {
    }

    public record PublicationMessageRequest(String name, String correlationKey, Long timeToLive, String messageId, Map<String, Object> variables, String tenantId) {
    }
}

