/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.CamundaServiceException;
import io.camunda.service.entities.IncidentEntity;
import io.camunda.service.exception.NotFoundException;
import io.camunda.service.search.core.SearchQueryService;
import io.camunda.service.search.query.IncidentQuery;
import io.camunda.service.search.query.SearchQueryBuilders;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.util.ObjectBuilder;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerResolveIncidentRequest;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class IncidentServices
extends SearchQueryService<IncidentServices, IncidentQuery, IncidentEntity> {
    public IncidentServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public SearchQueryResult<IncidentEntity> search(Function<IncidentQuery.Builder, ObjectBuilder<IncidentQuery>> fn) {
        return this.search(SearchQueryBuilders.incidentSearchQuery(fn));
    }

    @Override
    public SearchQueryResult<IncidentEntity> search(IncidentQuery query) {
        return this.executor.search(query, IncidentEntity.class);
    }

    @Override
    public IncidentServices withAuthentication(Authentication authentication) {
        return new IncidentServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    public IncidentEntity getByKey(Long key) {
        SearchQueryResult<IncidentEntity> result = this.executor.search(SearchQueryBuilders.incidentSearchQuery().filter(f -> f.keys(key, new Long[0])).build(), IncidentEntity.class);
        if (result.total() < 1L) {
            throw new NotFoundException(String.format("Incident with key %d not found", key));
        }
        if (result.total() > 1L) {
            throw new CamundaServiceException(String.format("Found Incident with key %d more than once", key));
        }
        return (IncidentEntity)result.items().stream().findFirst().orElseThrow();
    }

    public CompletableFuture<IncidentRecord> resolveIncident(long incidentKey) {
        return this.sendBrokerRequest(new BrokerResolveIncidentRequest(incidentKey));
    }
}

