/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.ApiServices;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerClockPinRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerClockResetRequest;
import io.camunda.zeebe.protocol.impl.record.value.clock.ClockRecord;
import java.util.concurrent.CompletableFuture;

public final class ClockServices
extends ApiServices<ClockServices> {
    public ClockServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public ClockServices withAuthentication(Authentication authentication) {
        return new ClockServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    public CompletableFuture<ClockRecord> pinClock(long pinnedEpoch) {
        return this.sendBrokerRequest(new BrokerClockPinRequest(pinnedEpoch));
    }

    public CompletableFuture<ClockRecord> resetClock() {
        return this.sendBrokerRequest(new BrokerClockResetRequest());
    }
}

