/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.os.transformers.sort;

import io.camunda.search.clients.sort.SearchFieldSort;
import io.camunda.search.os.transformers.OpensearchTransformer;
import io.camunda.search.os.transformers.OpensearchTransformers;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.SortOptionsBuilders;
import org.opensearch.client.opensearch._types.SortOrder;

public final class FieldSortTransformer
extends OpensearchTransformer<SearchFieldSort, FieldSort> {
    public FieldSortTransformer(OpensearchTransformers transformers) {
        super(transformers);
    }

    public FieldSort apply(SearchFieldSort value) {
        String field = value.field();
        SortOrder order = this.toSortOrder(value);
        String missing = value.missing();
        FieldSort.Builder builder = SortOptionsBuilders.field().field(field).order(order);
        return missing == null ? builder.build() : builder.missing(FieldValue.of((String)missing)).build();
    }

    private SortOrder toSortOrder(SearchFieldSort value) {
        if (value != null) {
            if (value.asc()) {
                return SortOrder.Asc;
            }
            if (value.desc()) {
                return SortOrder.Desc;
            }
        }
        return null;
    }
}

